/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.logger;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import ru.turikhay.tlauncher.logger.LoggerBuffer;
import ru.turikhay.tlauncher.logger.LoggerInterface;

@Plugin(name="SwingLogger", category="Core", elementType="appender")
public class SwingLoggerAppender
extends AbstractAppender {
    private LoggerInterface li = new LoggerBuffer();

    protected SwingLoggerAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public LoggerInterface getLoggerInterface() {
        return this.li;
    }

    public void setLoggerInterface(LoggerInterface li) {
        this.li = li;
    }

    public void append(LogEvent event) {
        String message = new String(this.getLayout().toByteArray(event), StandardCharsets.UTF_8);
        this.li.print(message);
    }

    @PluginFactory
    public static SwingLoggerAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for StubAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new SwingLoggerAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, null);
    }
}

