/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.logger;

import ru.turikhay.tlauncher.logger.LoggerInterface;

public class LoggerBuffer
implements LoggerInterface {
    private final int capacity;
    private StringBuilder buffer;

    public LoggerBuffer() {
        this(16384);
    }

    LoggerBuffer(int capacity) {
        this.capacity = capacity;
        this.buffer = new StringBuilder(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String message) {
        StringBuilder buffer = this.buffer;
        if (buffer != null) {
            StringBuilder stringBuilder = buffer;
            synchronized (stringBuilder) {
                if (buffer.length() + message.length() >= this.capacity) {
                    buffer.setLength(0);
                }
                buffer.append(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String drain() {
        StringBuilder buffer = this.buffer;
        if (buffer == null) {
            return null;
        }
        StringBuilder stringBuilder = buffer;
        synchronized (stringBuilder) {
            String string;
            try {
                string = buffer.toString();
                this.cleanup();
            }
            catch (Throwable throwable) {
                this.cleanup();
                throw throwable;
            }
            return string;
        }
    }

    public void cleanup() {
        if (this.buffer != null) {
            this.buffer = null;
        }
    }
}

