/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.logger;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.CharsetData;
import ru.turikhay.util.FileUtil;

public class LogFile
implements CharsetData {
    private static final Logger LOGGER = LogManager.getLogger(LogFile.class);
    private final File file;
    private final Charset charset;
    private long length = Long.MIN_VALUE;

    public LogFile(File file, Charset charset) {
        this.file = file;
        this.charset = charset;
    }

    public File getFile() {
        return this.file;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public InputStreamReader read() throws IOException {
        this.createIfNotExist();
        return new InputStreamReader(this.stream(), this.charset);
    }

    @Override
    public InputStream stream() throws IOException {
        this.createIfNotExist();
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public Charset charset() {
        return this.getCharset();
    }

    @Override
    public long length() {
        if (this.length == Long.MIN_VALUE) {
            this.length = LogFile.requestFileSize(this.file);
        }
        return this.length;
    }

    public OutputStreamWriter write() throws IOException {
        this.createIfNotExist();
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.file)), this.charset);
    }

    private void createIfNotExist() throws IOException {
        FileUtil.createFile(this.file);
    }

    private static long requestFileSize(File file) {
        BasicFileAttributes attributes;
        try {
            attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't read attributes of {}", (Object)file.getAbsolutePath(), (Object)e);
            return -1L;
        }
        return attributes.size();
    }

    public static LogFile usingUTF8(File file) {
        return new LogFile(file, StandardCharsets.UTF_8);
    }
}

