/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.logger;

import java.io.File;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import ru.turikhay.tlauncher.logger.LogFile;
import ru.turikhay.tlauncher.logger.SwingLoggerAppender;

public final class Log4j2ContextHelper {
    public static LoggerContext getContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    public static <A extends Appender> A getAppender(String name, Class<A> appenderClass) {
        Appender appender = Log4j2ContextHelper.getContext().getConfiguration().getAppender(name);
        if (appender == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "couldn't find appender %s of class %s", name, appenderClass.getSimpleName()));
        }
        if (!appenderClass.isInstance(appender)) {
            throw new RuntimeException(String.format(Locale.ROOT, "expected appender %s to be %s, but got %s", name, appenderClass.getSimpleName(), appender.getClass().getSimpleName()));
        }
        return (A)((Appender)appenderClass.cast(appender));
    }

    public static SwingLoggerAppender getSwingLoggerAppender() {
        return Log4j2ContextHelper.getAppender("swingLogger", SwingLoggerAppender.class);
    }

    public static LogFile getCurrentLogFile() {
        RollingFileAppender fileAppender = Log4j2ContextHelper.getAppender("file", RollingFileAppender.class);
        return LogFile.usingUTF8(new File(fileAppender.getFileName()));
    }

    private Log4j2ContextHelper() {
    }
}

