/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemoteList;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemoteListDeserializer;
import ru.turikhay.tlauncher.repository.RepositoryProxy;
import ru.turikhay.util.async.AsyncThread;

public class JavaRuntimeRemoteListFetcher {
    private static final Logger LOGGER = LogManager.getLogger(JavaRuntimeRemoteListFetcher.class);
    private Future<JavaRuntimeRemoteList> list;

    public Future<JavaRuntimeRemoteList> fetch() {
        if (this.list == null) {
            this.list = AsyncThread.future(this::doFetch);
        }
        return this.list;
    }

    public JavaRuntimeRemoteList fetchNow() throws ExecutionException, InterruptedException {
        return this.fetch().get();
    }

    private JavaRuntimeRemoteList doFetch() throws Exception {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(JavaRuntimeRemoteList.class, (Object)new JavaRuntimeRemoteListDeserializer()).registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(false)).create();
            String content = RepositoryProxy.requestMaybeProxy("https://launchermeta.mojang.com/v1/products/java-runtime/2ec0cc96c44e5a76b9c8b7c39df7210883d12871/all.json");
            JavaRuntimeRemoteList remoteList = (JavaRuntimeRemoteList)gson.fromJson(content, JavaRuntimeRemoteList.class);
            return Objects.requireNonNull(remoteList, "remoteList");
        }
        catch (Exception e) {
            LOGGER.warn("Failed", (Throwable)e);
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't fetch remote runtime list").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
            throw e;
        }
    }
}

