/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemote;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemoteList;

public class JavaRuntimeRemoteListDeserializer
implements JsonDeserializer<JavaRuntimeRemoteList> {
    public JavaRuntimeRemoteList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        HashMap<String, JavaRuntimeRemoteList.Platform> perPlatform = new HashMap<String, JavaRuntimeRemoteList.Platform>();
        JsonObject object = json.getAsJsonObject();
        for (Map.Entry platformEntry : object.entrySet()) {
            String platformName = (String)platformEntry.getKey();
            JsonObject platformObject = ((JsonElement)platformEntry.getValue()).getAsJsonObject();
            ArrayList<JavaRuntimeRemote> runtimeList = new ArrayList<JavaRuntimeRemote>();
            for (Map.Entry platformObjectEntry : platformObject.entrySet()) {
                String runtimeName = (String)platformObjectEntry.getKey();
                for (JsonElement runtime : ((JsonElement)platformObjectEntry.getValue()).getAsJsonArray()) {
                    runtimeList.add(this.deserializeRuntimeEntry(runtimeName, platformName, runtime.getAsJsonObject(), context));
                }
            }
            perPlatform.put(platformName, new JavaRuntimeRemoteList.Platform(platformName, runtimeList));
        }
        return new JavaRuntimeRemoteList(perPlatform);
    }

    private JavaRuntimeRemote deserializeRuntimeEntry(String name, String platform, JsonObject object, JsonDeserializationContext context) throws JsonParseException {
        JavaRuntimeRemote result = (JavaRuntimeRemote)context.deserialize((JsonElement)object, JavaRuntimeRemote.class);
        result.setName(name);
        result.setPlatform(platform);
        return result;
    }
}

