/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.launcher.updater.DownloadInfo;
import ru.turikhay.tlauncher.jre.JavaRuntime;
import ru.turikhay.tlauncher.jre.JavaRuntimeLocal;
import ru.turikhay.tlauncher.jre.JavaRuntimeManifest;
import ru.turikhay.tlauncher.repository.RepositoryProxy;
import ru.turikhay.util.async.AsyncThread;

public class JavaRuntimeRemote
implements JavaRuntime {
    private String name;
    private String platform;
    private Availability availability;
    private DownloadInfo manifest;
    private VersionInfo version;
    private volatile Future<JavaRuntimeManifest> manifestTimeout;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public JavaRuntimeManifest getManifest() throws ExecutionException, InterruptedException {
        if (this.manifestTimeout == null) {
            this.manifestTimeout = AsyncThread.future(this::getManifestNow);
        }
        return this.manifestTimeout.get();
    }

    private JavaRuntimeManifest getManifestNow() throws IOException {
        JavaRuntimeManifest manifest = (JavaRuntimeManifest)JavaRuntimeManifest.getGson().fromJson(RepositoryProxy.requestMaybeProxy(this.manifest.getUrl()), JavaRuntimeManifest.class);
        return Objects.requireNonNull(manifest, "manifest");
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public File getRuntimeDir(File rootDir) {
        return new File(rootDir, this.name + File.separatorChar + this.platform);
    }

    public File getWorkingDir(File rootDir) {
        return new File(this.getRuntimeDir(rootDir), this.name);
    }

    public JavaRuntimeLocal toLocal(File rootDir) {
        return new JavaRuntimeLocal(this.name, this.platform, this.getRuntimeDir(rootDir));
    }

    void setName(String name) {
        this.name = name;
    }

    void setPlatform(String platform) {
        this.platform = platform;
    }

    public static class Availability {
        private int group;
        private int progress;

        public int getGroup() {
            return this.group;
        }

        public int getProgress() {
            return this.progress;
        }
    }

    public static class VersionInfo {
        private String name;
        private Date released;

        public String getName() {
            return this.name;
        }

        public Date getReleased() {
            return this.released;
        }
    }
}

