/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.launcher.updater.DownloadInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.jre.FileIntegrityEntry;
import ru.turikhay.tlauncher.jre.JavaRuntimeFileDownloadable;
import ru.turikhay.tlauncher.jre.JavaRuntimeManifestDeserializer;

public class JavaRuntimeManifest {
    private static final Logger LOGGER = LogManager.getLogger(JavaRuntimeManifest.class);
    private final List<RuntimeFile> files;
    private static Gson GSON;

    JavaRuntimeManifest(List<RuntimeFile> files) {
        this.files = files;
    }

    public List<RuntimeFile> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public long countBytes() {
        return this.files.stream().filter(RuntimeFile::isFile).mapToLong(file -> file.getDownload().getSize()).count();
    }

    public List<Downloadable> toDownloadableList(File workingDir, boolean forceDownload) {
        return this.files.stream().filter(RuntimeFile::isFile).map(file -> file.createDownloadable(workingDir, forceDownload)).collect(Collectors.toList());
    }

    public List<FileIntegrityEntry> toIntegrityEntries() {
        return this.files.stream().filter(RuntimeFile::isFile).map(RuntimeFile::toIntegrityEntry).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static Gson getGson() {
        if (GSON == null) {
            GSON = new GsonBuilder().registerTypeAdapter(JavaRuntimeManifest.class, (Object)new JavaRuntimeManifestDeserializer()).create();
        }
        return GSON;
    }

    public static class RuntimeFile {
        private String path;
        private String type;
        private Map<String, DownloadInfo> downloads;
        private boolean executable;

        public String getPath() {
            return this.path;
        }

        void setPath(String path) {
            this.path = path;
        }

        public boolean isExecutable() {
            return this.executable;
        }

        public String getType() {
            return this.type;
        }

        public boolean isFile() {
            return "file".equals(this.type);
        }

        public boolean isDirectory() {
            return "directory".equals(this.type);
        }

        public boolean hasLzmaDownload() {
            return this.downloads.containsKey("lzma");
        }

        public DownloadInfo getLzmaDownload() {
            return this.downloads.get("lzma");
        }

        public DownloadInfo getDownload() {
            return this.downloads.get("raw");
        }

        public Downloadable createDownloadable(File workingDir, boolean forceDownload) {
            File destination = new File(workingDir, this.path);
            boolean isLzma = this.hasLzmaDownload();
            return new JavaRuntimeFileDownloadable(isLzma ? this.getLzmaDownload() : this.getDownload(), isLzma, destination, this.executable, forceDownload);
        }

        FileIntegrityEntry toIntegrityEntry() {
            DownloadInfo download = this.getDownload();
            if (download == null) {
                LOGGER.warn("file doesn't contain raw download: {}", (Object)this);
                return null;
            }
            return new FileIntegrityEntry(this.path, download.getSha1(), 0L);
        }

        public String toString() {
            return "RuntimeFile{path='" + this.path + '\'' + ", type='" + this.type + '\'' + ", downloads=" + this.downloads + ", executable=" + this.executable + '}';
        }
    }
}

