/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import ru.turikhay.tlauncher.jre.JavaPlatform;
import ru.turikhay.tlauncher.jre.JavaRuntime;

public class JavaRuntimeLocal
implements JavaRuntime {
    private final String name;
    private final String platform;
    private final File directory;

    public JavaRuntimeLocal(String name, String platform, File directory) {
        this.name = Objects.requireNonNull(name);
        this.platform = Objects.requireNonNull(platform);
        this.directory = Objects.requireNonNull(directory);
    }

    public String getVersion() throws IOException {
        return FileUtils.readFileToString((File)new File(this.directory, ".version"), (Charset)StandardCharsets.UTF_8);
    }

    public void writeVersion(String version) throws IOException {
        FileUtils.writeStringToFile((File)new File(this.directory, ".version"), (String)version, (Charset)StandardCharsets.UTF_8);
    }

    public boolean hasOverride() {
        if (!this.directory.isDirectory()) {
            return false;
        }
        File[] files = this.directory.listFiles();
        if (files == null) {
            return false;
        }
        return Arrays.stream(files).anyMatch(file -> file.getName().startsWith("override"));
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getWorkingDirectory() {
        return new File(this.directory, this.name);
    }

    public File getExecutableFile() {
        String path;
        Objects.requireNonNull(this.platform, "platform");
        switch (JavaPlatform.getOSByPlatform(this.platform)) {
            case LINUX: {
                path = "bin/java";
                break;
            }
            case WINDOWS: {
                path = "bin\\javaw.exe";
                break;
            }
            case OSX: {
                path = "jre.bundle/Contents/Home/bin/java";
                break;
            }
            default: {
                throw new RuntimeException("unsupported OS");
            }
        }
        return new File(this.getWorkingDirectory(), path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }
}

