/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.launcher.updater.DownloadInfo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tukaani.xz.LZMAInputStream;
import ru.turikhay.tlauncher.jre.JavaRuntimeInstallerProcess;
import ru.turikhay.tlauncher.jre.JavaRuntimeManifest;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemote;
import ru.turikhay.tlauncher.jre.ProgressReporter;
import ru.turikhay.util.EHttpClient;
import ru.turikhay.util.FileUtil;

public class JavaRuntimeInstallerDirect
implements JavaRuntimeInstallerProcess {
    private static final Logger LOGGER = LogManager.getLogger(JavaRuntimeInstallerDirect.class);
    private final JavaRuntimeRemote runtimeInfo;
    private final File runtimeDir;
    private final File workingDir;
    private ProgressReporter reporter;
    private List<JavaRuntimeManifest.RuntimeFile> runtimeFiles;
    private List<MissingFile> missingFiles;
    private HttpClient client;

    public JavaRuntimeInstallerDirect(File rootDir, JavaRuntimeRemote runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
        this.runtimeDir = runtimeInfo.getRuntimeDir(rootDir);
        this.workingDir = runtimeInfo.getWorkingDir(rootDir);
    }

    @Override
    public void install(ProgressReporter reporter) throws IOException, InterruptedException {
        JavaRuntimeManifest manifest;
        this.reporter = reporter;
        if (!this.workingDir.isDirectory()) {
            LOGGER.debug("Creating working directory: {}", (Object)this.workingDir.getAbsolutePath());
            FileUtil.createFolder(this.workingDir);
        } else {
            LOGGER.debug("Working directory: {}", (Object)this.workingDir.getAbsolutePath());
        }
        LOGGER.debug("Getting manifest");
        try {
            manifest = this.runtimeInfo.getManifest();
        }
        catch (ExecutionException e) {
            throw new IOException("Couldn't fetch manifest", e);
        }
        this.runtimeFiles = manifest.getFiles();
        JavaRuntimeInstallerDirect.checkInterrupted();
        LOGGER.debug("Reporting initial progress");
        reporter.reportProgress(0L, this.runtimeFiles.size());
        LOGGER.debug("Ensuring all files are intact");
        this.missingFiles = this.listMissingFiles();
        if (this.missingFiles.isEmpty()) {
            LOGGER.info("Nothing to download. All files are intact.");
        } else {
            LOGGER.info("Will download {} files", (Object)this.missingFiles.size());
            this.downloadFiles();
            LOGGER.info("Downloaded {} files", (Object)this.missingFiles.size());
        }
        LOGGER.debug("Writing version");
        FileUtils.writeStringToFile((File)new File(this.runtimeDir, ".version"), (String)this.runtimeInfo.getVersion().getName(), (Charset)StandardCharsets.UTF_8);
        LOGGER.info("Installation finished");
        reporter.reportProgress(this.runtimeFiles.size(), this.runtimeFiles.size());
    }

    private List<MissingFile> listMissingFiles() throws IOException, InterruptedException {
        ArrayList<MissingFile> missingFiles = new ArrayList<MissingFile>();
        for (JavaRuntimeManifest.RuntimeFile runtimeFile : this.runtimeFiles) {
            MissingFile missingFile = new MissingFile(runtimeFile);
            if (missingFile.shouldDownload()) {
                missingFiles.add(missingFile);
            }
            JavaRuntimeInstallerDirect.checkInterrupted();
        }
        LOGGER.debug("Missing files count: {}", (Object)missingFiles.size());
        return missingFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFiles() throws IOException, InterruptedException {
        try (CloseableHttpClient httpClient = EHttpClient.createRepeatable();){
            this.client = httpClient;
            for (int i = 0; i < this.missingFiles.size(); ++i) {
                this.missingFiles.get(i).download();
                this.reporter.reportProgress(i + 1, this.missingFiles.size());
                JavaRuntimeInstallerDirect.checkInterrupted();
            }
        }
        finally {
            this.client = null;
        }
    }

    private static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private class MissingFile {
        final JavaRuntimeManifest.RuntimeFile runtimeFile;
        final String path;
        final File realFile;

        MissingFile(JavaRuntimeManifest.RuntimeFile runtimeFile) {
            this.runtimeFile = runtimeFile;
            this.path = runtimeFile.getPath();
            this.realFile = new File(JavaRuntimeInstallerDirect.this.workingDir, this.path);
        }

        boolean shouldDownload() throws IOException {
            LOGGER.trace("Inspecting runtime entity {}", (Object)this.path);
            if (!this.runtimeFile.isFile()) {
                LOGGER.debug("Not a file: {}", (Object)this.path);
                return false;
            }
            File realFile = new File(JavaRuntimeInstallerDirect.this.workingDir, this.path);
            if (!realFile.isFile()) {
                LOGGER.trace("File is missing: {}", (Object)this.path);
                return true;
            }
            int expectedSize = this.runtimeFile.getDownload().getSize();
            long size = FileUtil.getSize(realFile);
            if (size < 0L) {
                LOGGER.warn("Reported negative size ({}): {}", (Object)size, (Object)realFile.getAbsolutePath());
            } else if (size != (long)expectedSize) {
                LOGGER.info("File {} is corrupted. Expected size {}, but got {}", (Object)this.path, (Object)expectedSize, (Object)size);
                return true;
            }
            String expectedSha1 = this.runtimeFile.getDownload().getSha1();
            String sha1 = FileUtil.getSha1(realFile);
            if (!sha1.equalsIgnoreCase(expectedSha1)) {
                LOGGER.info("File {} is corrupted. Expected SHA-1 {}, but got {}", (Object)this.path, (Object)expectedSha1, (Object)sha1);
                return true;
            }
            LOGGER.trace("File {} is ok", (Object)this.path);
            return false;
        }

        void download() throws IOException, InterruptedException {
            if (this.runtimeFile.hasLzmaDownload()) {
                LOGGER.debug("Downloading compressed (LZMA) file: {}", (Object)this.runtimeFile.getPath());
                this.downloadLzma();
            } else {
                LOGGER.debug("Downloading uncompressed file: {}", (Object)this.runtimeFile.getPath());
                this.downloadRaw();
            }
        }

        private void downloadLzma() throws IOException, InterruptedException {
            File lzmaFile = new File(JavaRuntimeInstallerDirect.this.workingDir, this.path + ".lzma");
            this.downloadAndCheck(this.runtimeFile.getLzmaDownload(), lzmaFile);
            LOGGER.debug("Decompressing: {}", (Object)lzmaFile.getAbsolutePath());
            try (LZMAInputStream input = new LZMAInputStream((InputStream)new BufferedInputStream(new FileInputStream(lzmaFile)));
                 BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.realFile));){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            catch (IOException e) {
                throw new IOException(this.path + ": couldn't decompress the file", e);
            }
            finally {
                FileUtil.deleteFile(lzmaFile);
            }
            this.checkFile(this.runtimeFile.getDownload(), this.realFile);
        }

        private void downloadRaw() throws IOException, InterruptedException {
            this.downloadAndCheck(this.runtimeFile.getDownload(), this.realFile);
        }

        private void downloadAndCheck(DownloadInfo downloadInfo, File file) throws IOException, InterruptedException {
            LOGGER.trace("Downloading {} into {}", (Object)downloadInfo, (Object)file.getAbsolutePath());
            HttpGet get = new HttpGet(downloadInfo.getUrl());
            try (InputStream in = JavaRuntimeInstallerDirect.this.client.execute((HttpUriRequest)get).getEntity().getContent();
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (InterruptedIOException interrupted) {
                throw new InterruptedException();
            }
            this.checkFile(downloadInfo, file);
            LOGGER.debug("Downloaded successfully: {}", (Object)file.getAbsolutePath());
        }

        private void checkFile(DownloadInfo downloadInfo, File file) throws IOException {
            LOGGER.trace("Checking file: {} ({})", (Object)file.getAbsolutePath(), (Object)downloadInfo.getSha1());
            long size = FileUtil.getSize(file);
            if (size < 0L) {
                LOGGER.warn("System reported this file has negative file size({}): {}", (Object)size, (Object)file.getAbsolutePath());
            } else if (size != (long)downloadInfo.getSize()) {
                throw new IOException(this.path + ": unexpected file size: " + size + "; expected: " + downloadInfo.getSize());
            }
            String sha1 = FileUtil.getSha1(file);
            if (!downloadInfo.getSha1().equalsIgnoreCase(sha1)) {
                throw new IOException(this.path + ": bad checksum: " + sha1 + "; expected: " + downloadInfo.getSha1());
            }
        }
    }
}

