/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.launcher.updater.DownloadInfo;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tukaani.xz.LZMAInputStream;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.downloader.Sha1Downloadable;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.async.AsyncThread;

public class JavaRuntimeFileDownloadable
extends Sha1Downloadable {
    private static final Logger LOGGER = LogManager.getLogger(JavaRuntimeFileDownloadable.class);
    private final File lzmaDestination;
    private final File destination;
    private final boolean executable;

    JavaRuntimeFileDownloadable(DownloadInfo info, boolean isLzma, File destination, boolean executable, boolean forceDownload) {
        super(Repository.PROXIFIED_REPO, info.getUrl(), isLzma ? new File(destination.getAbsolutePath() + ".lzma") : destination, forceDownload);
        this.lzmaDestination = isLzma ? this.getDestination() : null;
        this.destination = destination;
        this.executable = executable;
        this.sha1 = info.getSha1();
        this.length = info.getSize();
    }

    @Override
    protected void onComplete() throws RetryDownloadException {
        super.onComplete();
        if (this.lzmaDestination != null) {
            this.syncExtract();
        }
        if (this.executable) {
            LOGGER.debug("Setting as executable: {}", (Object)this.destination.getAbsolutePath());
            this.destination.setExecutable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncExtract() throws RetryDownloadException {
        Class<JavaRuntimeFileDownloadable> clazz = JavaRuntimeFileDownloadable.class;
        synchronized (JavaRuntimeFileDownloadable.class) {
            this.doExtract();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void doExtract() throws RetryDownloadException {
        LOGGER.debug("Extracting {}", (Object)this.lzmaDestination.getAbsolutePath());
        try (LZMAInputStream input = new LZMAInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.lzmaDestination)));
             BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.destination));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            throw new RetryDownloadException("couldn't unpack file", e);
        }
        finally {
            if (OS.WINDOWS.isCurrent()) {
                AsyncThread.afterSeconds(10L, () -> FileUtil.deleteFile(this.lzmaDestination));
            } else {
                FileUtil.deleteFile(this.lzmaDestination);
            }
        }
    }
}

