/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jre;

import java.io.File;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.FileUtil;

public class FileIntegrityEntry {
    private static final Logger LOGGER = LogManager.getLogger(FileIntegrityEntry.class);
    private final String path;
    private final String sha1;
    private final long lastModifiedNanos;

    public FileIntegrityEntry(String path, String sha1, long lastModifiedNanos) {
        this.path = Objects.requireNonNull(path);
        this.sha1 = Objects.requireNonNull(sha1);
        this.lastModifiedNanos = lastModifiedNanos;
    }

    public File resolve(File directory) {
        return new File(Objects.requireNonNull(directory), this.path);
    }

    public boolean isTamperedWithAt(File directory) {
        File file = this.resolve(directory);
        if (!file.isFile()) {
            LOGGER.debug("File doesn't exist: {}", (Object)file.getAbsolutePath());
            return true;
        }
        String sha1 = FileUtil.getSHA(file);
        if (this.sha1.equals(sha1)) {
            return false;
        }
        LOGGER.debug("File was tampered with: {} (got {}, expected {})", (Object)file.getAbsolutePath(), (Object)sha1, (Object)this.sha1);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileIntegrityEntry that = (FileIntegrityEntry)o;
        if (this.lastModifiedNanos != that.lastModifiedNanos) {
            return false;
        }
        if (!this.path.equals(that.path)) {
            return false;
        }
        return this.sha1.equals(that.sha1);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.sha1.hashCode();
        result = 31 * result + (int)(this.lastModifiedNanos ^ this.lastModifiedNanos >>> 32);
        return result;
    }

    public String toString() {
        return this.path + " /#// " + this.sha1 + " " + this.lastModifiedNanos;
    }
}

