/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jna;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import java.util.Optional;
import ru.turikhay.tlauncher.jna.JNA;
import ru.turikhay.tlauncher.jna.JNAException;
import ru.turikhay.util.Lazy;

public class JNAWindows {
    private static final Lazy<?> OSVERSIONINFOEX = Lazy.of(() -> {
        WinNT.OSVERSIONINFOEX vex = new WinNT.OSVERSIONINFOEX();
        if (Kernel32.INSTANCE.GetVersionEx(vex)) {
            return vex;
        }
        return null;
    });
    private static final Lazy<Integer> BUILD_NUMBER = Lazy.of(() -> ((WinNT.OSVERSIONINFOEX)OSVERSIONINFOEX.get()).getBuildNumber());
    private static final Lazy<Registry> REGISTRY = Lazy.of(() -> Platform.isWindows() ? new Registry() : null);

    public static Optional<Integer> getBuildNumber() {
        return JNA.ENABLED ? BUILD_NUMBER.value() : Optional.empty();
    }

    public static Optional<Registry> getRegistry() {
        return JNA.ENABLED ? REGISTRY.value() : Optional.empty();
    }

    public static class Registry {
        private Registry() {
        }

        public boolean exists(WinReg.HKEY root, String key) throws JNAException {
            try {
                return Advapi32Util.registryKeyExists((WinReg.HKEY)root, (String)key);
            }
            catch (Exception e) {
                throw new JNAException(e);
            }
        }

        public boolean exists(WinReg.HKEY root, String key, String name) throws JNAException {
            try {
                return Advapi32Util.registryValueExists((WinReg.HKEY)root, (String)key, (String)name);
            }
            catch (Exception e) {
                throw new JNAException(e);
            }
        }

        public String getString(WinReg.HKEY root, String key, String name) throws JNAException {
            try {
                if (!this.exists(root, key, name)) {
                    return null;
                }
                return Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)key, (String)name);
            }
            catch (JNAException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JNAException(e);
            }
        }

        public void setString(WinReg.HKEY root, String key, String name, String value) throws JNAException {
            try {
                if (!this.exists(root, key)) {
                    Advapi32Util.registryCreateKey((WinReg.HKEY)root, (String)key);
                }
                Advapi32Util.registrySetStringValue((WinReg.HKEY)root, (String)key, (String)name, (String)value);
            }
            catch (JNAException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JNAException(e);
            }
        }
    }
}

