/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.jna;

import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.platform.unix.LibCAPI;
import com.sun.jna.ptr.IntByReference;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.jna.JNA;
import ru.turikhay.util.Lazy;

public class JNAMacOs {
    private static final Logger LOGGER = LogManager.getLogger(JNAMacOs.class);
    private static final Lazy<Boolean> IS_UNDER_ROSETTA = Lazy.of(() -> {
        IntByReference p = new IntByReference();
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference((long)SystemB.INT_SIZE);
        int result = SystemB.INSTANCE.sysctlbyname("sysctl.proc_translated", p.getPointer(), size, null, LibCAPI.size_t.ZERO);
        if (result == -1) {
            LOGGER.warn("Couldn't request \"sysctl.proc_translated\" property");
            return false;
        }
        return p.getValue() == 1;
    });

    public static Optional<Boolean> isUnderRosetta() {
        return JNA.ENABLED ? IS_UNDER_ROSETTA.value() : Optional.empty();
    }
}

