/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.handlers;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.background.ImageBackground;
import ru.turikhay.util.U;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ExceptionHandler instance;
    private static long gcLastCall;
    private static final String[] lastMessages;
    private static int lastWrittenMessage;

    public static ExceptionHandler getInstance() {
        if (instance == null) {
            instance = new ExceptionHandler();
        }
        return instance;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!(e instanceof OutOfMemoryError)) {
            return;
        }
        try {
            OutOfMemoryError asOOM = (OutOfMemoryError)e;
            if (!ExceptionHandler.reduceMemory(asOOM)) {
                if (ExceptionHandler.scanTrace(e) && ExceptionHandler.toShowError(e)) {
                    Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("uncaught exception: " + e).withSentryInterface((SentryInterface)new ExceptionInterface(e)).withExtra("thread", (Object)t.getName()));
                    try {
                        Alert.showError("Exception in thread " + t.getName(), e);
                    }
                    catch (Exception var5) {
                        var5.printStackTrace();
                    }
                } else {
                    LOGGER.debug("Hidden exception in thread {}", (Object)t.getName(), (Object)e);
                }
            }
        }
        catch (Throwable t0) {
            t0.printStackTrace();
        }
    }

    public static boolean reduceMemory(OutOfMemoryError e) {
        long currentTime;
        long diff;
        if (e == null) {
            return false;
        }
        LOGGER.fatal("OutOfMemory error has occurred");
        if (ImageBackground.getLastInstance() != null) {
            ImageBackground.getLastInstance().wipe();
        }
        if ((diff = Math.abs((currentTime = System.currentTimeMillis()) - gcLastCall)) > 5000L) {
            gcLastCall = currentTime;
            LOGGER.info("Starting garbage collector: " + U.memoryStatus());
            System.gc();
            LOGGER.info("Garbage collector completed: " + U.memoryStatus());
            return true;
        }
        LOGGER.fatal("GC is unable to reduce memory usage");
        return false;
    }

    private static boolean scanTrace(Throwable e) {
        for (StackTraceElement element : e.getStackTrace()) {
            if (!element.getClassName().startsWith("ru.turikhay")) continue;
            return true;
        }
        return false;
    }

    private static synchronized boolean toShowError(Throwable t) {
        if (t == null) {
            return false;
        }
        String message = t.toString();
        for (String lastMessage : lastMessages) {
            if (!message.equals(lastMessage)) continue;
            return false;
        }
        lastWrittenMessage = (lastWrittenMessage + 1) % lastMessages.length;
        ExceptionHandler.lastMessages[ExceptionHandler.lastWrittenMessage] = message;
        return true;
    }

    static {
        lastMessages = new String[10];
        lastWrittenMessage = -1;
    }
}

