/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.downloader;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.downloader.AbortedDownloadException;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.GaveUpDownloadException;
import ru.turikhay.tlauncher.downloader.PartialDownloadException;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.repository.IRepo;
import ru.turikhay.tlauncher.repository.RepositoryProxy;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;

public class DownloaderThread
extends ExtendedThread {
    private static final Logger LOGGER = LogManager.getLogger(DownloaderThread.class);
    private static final double SMOOTHING_FACTOR = 0.005;
    private static final String ITERATION_BLOCK = "iteration";
    private static final int NOTIFY_TIMER = 15000;
    private final int ID;
    private final Downloader downloader;
    private final List<Downloadable> list;
    private double currentProgress;
    private double doneProgress;
    private double eachProgress;
    private double speed;
    private Downloadable current;
    private boolean launched;
    private final byte[] HTML_SIGNATURE = new byte[]{60, 33, 68, 79, 67, 84, 89, 80, 69};
    double curdone;

    DownloaderThread(Downloader d, int id) {
        super("DT#" + id);
        this.ID = id;
        this.downloader = d;
        this.list = new ArrayList<Downloadable>();
        this.startAndWait();
    }

    int getID() {
        return this.ID;
    }

    void add(Downloadable d) {
        this.list.add(d);
    }

    void startDownload() {
        this.launched = true;
        this.unlockThread(ITERATION_BLOCK);
    }

    void stopDownload() {
        this.launched = false;
    }

    private boolean isHTML(File file) {
        byte[] buffer = new byte[this.HTML_SIGNATURE.length];
        try (FileInputStream is = new FileInputStream(file);){
            int i;
            for (int read = 0; read < this.HTML_SIGNATURE.length; read += i) {
                i = ((InputStream)is).read(buffer, read, buffer.length - read);
                if (i >= 0) continue;
                break;
            }
        }
        catch (IOException e) {
            return false;
        }
        return Arrays.equals(buffer, this.HTML_SIGNATURE);
    }

    @Override
    public void run() {
        while (true) {
            this.launched = true;
            this.eachProgress = 1.0 / (double)this.list.size();
            this.doneProgress = 0.0;
            this.currentProgress = 0.0;
            Iterator<Downloadable> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Downloadable d;
                this.current = d = iterator.next();
                this.onStart();
                int attempt = 0;
                Exception error = null;
                int max = d.isFast() ? 2 : 5;
                long skip = 0L;
                long length = 0L;
                while (attempt < max) {
                    ++attempt;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Downloading {}{} [{} / {}]", (Object)d.getURL(), (Object)(d.hasRepository() ? " (repo: " + d.getRepository().name() + ")" : ""), (Object)attempt, (Object)max);
                    }
                    int timeout = attempt * U.getConnectionTimeout();
                    try {
                        this.download(timeout, skip, length);
                        break;
                    }
                    catch (PartialDownloadException partial) {
                        LOGGER.debug("Partially downloaded file: {}", (Object)partial.getMessage());
                        attempt = -1;
                        skip = partial.getNextSkip();
                        length = partial.getLength();
                    }
                    catch (GaveUpDownloadException var9) {
                        LOGGER.debug("Cannot download file: {}", (Object)d.getURL());
                        skip = 0L;
                        length = 0L;
                        error = var9;
                        if (attempt < max) continue;
                        FileUtil.deleteFile(d.getDestination());
                        for (File downloadable : d.getAdditionalDestinations()) {
                            FileUtil.deleteFile(downloadable);
                        }
                        LOGGER.debug("Gave up trying to download: {}", (Object)d.getURL());
                        this.onError(var9);
                    }
                    catch (AbortedDownloadException var10) {
                        error = var10;
                        break;
                    }
                }
                if (!(error instanceof AbortedDownloadException)) continue;
                LOGGER.debug("Thread is aborting...");
                for (Downloadable downloadable : this.list) {
                    downloadable.onAbort((AbortedDownloadException)error);
                }
            }
            this.speed = 0.0;
            this.list.clear();
            this.lockThread(ITERATION_BLOCK);
            this.launched = false;
        }
    }

    private void download(int timeout, long skip, long length) throws PartialDownloadException, GaveUpDownloadException, AbortedDownloadException {
        Throwable cause = null;
        if (this.current.hasRepository()) {
            List<IRepo> list = this.current.getRepository().getRelevant().getList();
            int max = list.size();
            for (int attempt = 1; attempt <= max; ++attempt) {
                for (IRepo repo : list) {
                    URLConnection connection = null;
                    try {
                        connection = repo instanceof RepositoryProxy.ProxyRepo ? ((RepositoryProxy.ProxyRepo)repo).get(this.current.getURL(), attempt * U.getConnectionTimeout(), U.getProxy(), attempt) : repo.get(this.current.getURL(), attempt * U.getConnectionTimeout(), U.getProxy());
                        this.downloadURL(connection, timeout, skip, length);
                        return;
                    }
                    catch (AbortedDownloadException | PartialDownloadException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        LOGGER.debug("Failed to download: {}", connection == null ? this.current.getURL() : connection.getURL(), (Object)e);
                        this.current.getRepository().getList().markInvalid(repo);
                        if (cause == null) {
                            cause = e;
                            continue;
                        }
                        cause.addSuppressed(e);
                    }
                    catch (Throwable e) {
                        Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("downloader exception: " + e).withSentryInterface((SentryInterface)new ExceptionInterface(e)).withExtra("current", (Object)this.current));
                        LOGGER.error("Unknown error occurred while downloading {}", (Object)this.current.getURL(), (Object)e);
                        if (cause == null) {
                            cause = e;
                            continue;
                        }
                        cause.addSuppressed(e);
                    }
                }
            }
        } else {
            HttpURLConnection connection = null;
            try {
                connection = DownloaderThread.openConnection(this.current.getURL());
                this.downloadURL(connection, timeout, skip, length);
                return;
            }
            catch (AbortedDownloadException | PartialDownloadException e) {
                throw e;
            }
            catch (IOException e) {
                LOGGER.debug("Failed to download: {}", connection == null ? this.current.getURL() : connection.getURL(), (Object)e);
                cause = e;
            }
            catch (Throwable e) {
                Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("downloader exception: " + e).withSentryInterface((SentryInterface)new ExceptionInterface(e)).withExtra("current", (Object)this.current));
                LOGGER.error("Unknown error occurred while downloading {}", (Object)this.current.getURL(), (Object)e);
                cause = e;
            }
        }
        throw new GaveUpDownloadException(this.current, cause);
    }

    private static HttpURLConnection openConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection(U.getProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadURL(URLConnection urlConnection, int timeout, long skip, long length) throws IOException, AbortedDownloadException {
        double downloadSpeed;
        long downloaded_e;
        long downloaded_s;
        if (!(urlConnection instanceof HttpURLConnection)) {
            throw new IOException("invalid protocol");
        }
        long reply_s = System.currentTimeMillis();
        HttpURLConnection connection = this.setupConnectionFollowingRedirects((HttpURLConnection)urlConnection, timeout, skip, length);
        String contentType = connection.getHeaderField("Content-Type");
        LOGGER.debug("Content type: {}", (Object)contentType);
        if (!this.current.getURL().endsWith("html") && "text/html".equalsIgnoreCase(contentType)) {
            throw new RetryDownloadException("requested file is html");
        }
        long reply = System.currentTimeMillis() - reply_s;
        LOGGER.debug("Replied in {} ms", (Object)reply);
        File file = this.current.getDestination();
        File temp = new File(file.getAbsoluteFile() + ".download");
        if (skip == 0L) {
            if (temp.isFile()) {
                FileUtil.deleteFile(temp);
            }
            FileUtil.createFile(temp);
        } else {
            if (!temp.isFile()) {
                throw new FileNotFoundException("no partial file: " + temp.getAbsolutePath());
            }
            if (temp.length() != 0L && temp.length() != skip) {
                throw new IOException("bad partial file length: " + temp.length() + " (" + skip + " required)");
            }
        }
        long totalRead = skip;
        long read = 0L;
        long contentLength = connection.getContentLengthLong();
        if (length == 0L) {
            length = contentLength;
        }
        long speed_s = downloaded_s = System.currentTimeMillis();
        long timer = downloaded_s;
        byte[] buffer = new byte[8192];
        try (InputStream in = connection.getInputStream();){
            int curread = in.read(buffer);
            try (FileOutputStream out = new FileOutputStream(temp, skip > 0L);){
                while (curread > -1) {
                    double copies;
                    if (!this.launched) {
                        ((OutputStream)out).close();
                        throw new AbortedDownloadException();
                    }
                    totalRead += (long)curread;
                    read += (long)curread;
                    ((OutputStream)out).write(buffer, 0, curread);
                    curread = in.read(buffer);
                    if (curread == -1) {
                        break;
                    }
                    long speed_e = System.currentTimeMillis() - speed_s;
                    if (speed_e < 50L) continue;
                    speed_s = System.currentTimeMillis();
                    downloaded_e = speed_s - downloaded_s;
                    downloadSpeed = length > 0L ? (double)((float)totalRead / (float)length) : 0.0;
                    double d = copies = downloaded_e > 0L ? (double)totalRead / (double)downloaded_e : 0.0;
                    if (speed_s - timer > 15000L) {
                        timer = speed_s;
                        LOGGER.info("Downloading {} [{}%, {} KiB/s]", (Object)connection.getURL(), (Object)(downloadSpeed * 100.0), (Object)copies);
                    }
                    this.onProgress(downloadSpeed, copies);
                }
            }
        }
        finally {
            connection.disconnect();
        }
        if (length > 0L && totalRead != length) {
            if (skip == 0L) {
                String partialInfo = "read " + totalRead + " out of " + length;
                if (!"bytes".equals(connection.getHeaderField("Accept-Ranges"))) {
                    throw new IOException("server doesn't support partial download. " + partialInfo);
                }
            }
            throw new PartialDownloadException(skip, read, length);
        }
        downloaded_e = System.currentTimeMillis() - downloaded_s;
        downloadSpeed = downloaded_e != 0L ? (double)totalRead / (double)downloaded_e : 0.0;
        FileUtil.copyFile(temp, file, true);
        FileUtil.deleteFile(temp);
        if (this.isHTML(file)) {
            throw new RetryDownloadException("Downloaded file is HTML");
        }
        List<File> copies = this.current.getAdditionalDestinations();
        if (copies.size() > 0) {
            for (File copy : copies) {
                LOGGER.debug("Copying {} -> {}", (Object)file, (Object)copy);
                FileUtil.copyFile(file, copy, this.current.isForce());
            }
            LOGGER.debug("Copying completed.");
        }
        LOGGER.debug("Downloaded {} in {} at {} KiB/s", (Object)(totalRead / 1024L + " KiB"), (Object)(downloaded_e + " ms"), (Object)String.format(Locale.ROOT, "%.0f", downloadSpeed));
        this.onComplete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpURLConnection setupConnectionFollowingRedirects(HttpURLConnection connection, int timeout, long skip, long length) throws IOException, AbortedDownloadException {
        boolean connected = false;
        try {
            LinkedHashSet<String> redirects = new LinkedHashSet<String>();
            do {
                String newLocation;
                LOGGER.debug("Downloading: {}", (Object)connection.getURL());
                Downloadable.setUp(connection, timeout, this.current.getInsertUA());
                if (skip > 0L) {
                    String range = skip + "-" + length;
                    LOGGER.debug("Requesting range {}", (Object)range);
                    connection.setRequestProperty("Range", "bytes=" + range);
                }
                if (!this.launched) {
                    throw new AbortedDownloadException();
                }
                connection.connect();
                if (skip > 0L && connection.getResponseCode() != 206) {
                    throw new IOException("expected 206 response for partial content");
                }
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    if (responseCode != 301 && responseCode != 302 && responseCode != 307 && responseCode != 308) throw new IOException("expected 200 response; got " + connection.getResponseCode());
                    newLocation = connection.getHeaderField("Location");
                    LOGGER.info("Following redirect ({}) {} -> {}", (Object)responseCode, (Object)connection.getURL(), (Object)newLocation);
                    if (!redirects.add(newLocation)) {
                        throw new IOException(String.format(Locale.ROOT, "circular redirect detected: %s (chain: %s)", newLocation, redirects));
                    }
                } else {
                    connected = true;
                    HttpURLConnection httpURLConnection = connection;
                    return httpURLConnection;
                }
                connection.disconnect();
                connection = DownloaderThread.openConnection(newLocation);
            } while (redirects.size() < 10);
            throw new IOException("too many redirects: " + redirects);
        }
        finally {
            if (!connected) {
                connection.disconnect();
            }
        }
    }

    private void onStart() {
        this.current.onStart();
    }

    private void onError(Throwable e) {
        this.current.onError(e);
        this.downloader.onFileComplete(this, this.current);
    }

    private void onProgress(double curdone, double curspeed) {
        this.curdone = curdone;
        this.currentProgress = this.doneProgress + this.eachProgress * curdone;
        this.speed = 0.005 * this.speed + 0.995 * curspeed;
        double lastProgress = this.currentProgress;
        this.downloader.onProgress(this, this.currentProgress, curdone, this.speed);
    }

    private void onComplete() throws RetryDownloadException {
        this.doneProgress += this.eachProgress;
        this.current.onComplete();
        this.downloader.onProgress(this, this.doneProgress, 1.0, this.speed);
        this.downloader.onFileComplete(this, this.current);
    }
}

