/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.downloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.downloader.DownloaderListener;
import ru.turikhay.tlauncher.downloader.DownloaderThread;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;

public class Downloader
extends ExtendedThread {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MAX_THREADS = 6;
    public static final String DOWNLOAD_BLOCK = "download";
    static final double SMOOTHING_FACTOR = 0.005;
    static final String ITERATION_BLOCK = "iteration";
    private final DownloaderThread[] threads;
    private final List<Downloadable> list;
    private final List<DownloaderListener> listeners;
    private final AtomicInteger remainingObjects = new AtomicInteger();
    private int runningThreads;
    private int workingThreads;
    private int busyThreads;
    private final double[] progressContainer;
    private double lastAverageProgress;
    private double averageProgress;
    private double lastProgress;
    private double speed;
    private boolean aborted;
    private final Object workLock;
    private boolean haveWork;

    public Downloader() {
        super("MD");
        this.threads = new DownloaderThread[6];
        this.list = Collections.synchronizedList(new ArrayList());
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.progressContainer = new double[6];
        this.workLock = new Object();
        this.startAndWait();
    }

    public int getRemaining() {
        return this.remainingObjects.get();
    }

    public double getLastProgress() {
        return this.lastProgress;
    }

    public double getProgress() {
        return this.averageProgress;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void add(Downloadable d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.list.add(d);
    }

    public void add(DownloadableContainer c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.list.addAll(c.list);
    }

    public void addAll(Downloadable ... ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < ds.length; ++i) {
            if (ds[i] == null) {
                throw new NullPointerException("Downloadable at " + i + " is NULL!");
            }
            this.list.add(ds[i]);
        }
    }

    public void addAll(Collection<Downloadable> coll) {
        if (coll == null) {
            throw new NullPointerException();
        }
        int i = -1;
        for (Downloadable d : coll) {
            ++i;
            if (d == null) {
                throw new NullPointerException("Downloadable at " + i + " is NULL!");
            }
            this.list.add(d);
        }
    }

    public void addListener(DownloaderListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public boolean startDownload() {
        boolean haveWork;
        boolean bl = haveWork = !this.list.isEmpty();
        if (haveWork) {
            this.unlockThread(ITERATION_BLOCK);
        }
        return haveWork;
    }

    public void startDownloadAndWait() {
        if (this.startDownload()) {
            this.waitWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWork() {
        this.haveWork = true;
        while (this.haveWork) {
            Object object = this.workLock;
            synchronized (object) {
                try {
                    this.workLock.wait();
                }
                catch (InterruptedException var3) {
                    var3.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWork() {
        this.haveWork = false;
        Object object = this.workLock;
        synchronized (object) {
            this.workLock.notifyAll();
        }
    }

    public void stopDownload() {
        if (!this.isThreadLocked()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.runningThreads; ++i) {
            this.threads[i].stopDownload();
        }
        this.aborted = true;
        if (this.isThreadLocked()) {
            this.tryUnlock(DOWNLOAD_BLOCK);
        }
    }

    public void stopDownloadAndWait() {
        this.stopDownload();
        this.waitForThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.checkCurrent();
        while (true) {
            this.lockThread(ITERATION_BLOCK);
            LOGGER.debug("Files in the queue: {}", (Object)this.list.size());
            List<Downloadable> list = this.list;
            synchronized (list) {
                this.sortOut();
            }
            for (int var3 = 0; var3 < this.runningThreads; ++var3) {
                this.threads[var3].startDownload();
            }
            this.lockThread(DOWNLOAD_BLOCK);
            if (this.aborted) {
                this.waitForThreads();
                this.onAbort();
                this.aborted = false;
            }
            this.notifyWork();
            Arrays.fill(this.progressContainer, 0.0);
            this.speed = 0.0;
            this.averageProgress = 0.0;
            this.lastAverageProgress = 0.0;
            this.workingThreads = 0;
            this.remainingObjects.set(0);
        }
    }

    private void sortOut() {
        int size = this.list.size();
        if (size != 0) {
            int downloadablesAtThread = U.getMaxMultiply(size, 6);
            int x = 0;
            boolean y = true;
            LOGGER.info("Starting to download {} files...", (Object)size);
            this.onStart(size);
            int max = 6;
            boolean[] workers = new boolean[max];
            while (size > 0) {
                for (int worker = 0; worker < max; ++worker) {
                    int var11;
                    workers[worker] = true;
                    size -= downloadablesAtThread;
                    if (this.threads[worker] == null) {
                        this.threads[worker] = new DownloaderThread(this, ++this.runningThreads);
                    }
                    for (var11 = x; var11 < x + downloadablesAtThread; ++var11) {
                        this.threads[worker].add(this.list.get(var11));
                    }
                    x = var11;
                    if (size == 0) break;
                }
                downloadablesAtThread = U.getMaxMultiply(size, 6);
            }
            boolean[] var10 = workers;
            int var9 = workers.length;
            for (int var8 = 0; var8 < var9; ++var8) {
                boolean var12 = var10[var8];
                if (!var12) continue;
                ++this.workingThreads;
            }
            this.list.clear();
        }
    }

    private void onStart(int size) {
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderStart(this, size);
        }
        this.remainingObjects.addAndGet(size);
    }

    void onAbort() {
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderAbort(this);
        }
    }

    void onProgress(DownloaderThread thread, double curprogress, double curdone, double curspeed) {
        int id = thread.getID() - 1;
        this.lastProgress = curdone;
        this.progressContainer[id] = curprogress;
        this.averageProgress = U.getAverage(this.progressContainer, this.workingThreads);
        if (this.remainingObjects.get() == 1 || this.averageProgress - this.lastAverageProgress >= 0.01) {
            this.speed = 0.005 * this.speed + 0.995 * curspeed;
            this.lastAverageProgress = this.averageProgress;
            for (DownloaderListener listener : this.listeners) {
                listener.onDownloaderProgress(this, this.averageProgress, this.speed);
            }
        }
    }

    void onFileComplete(DownloaderThread thread, Downloadable file) {
        int remaining = this.remainingObjects.decrementAndGet();
        LOGGER.debug("Remaining: {}", (Object)remaining);
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderFileComplete(this, file);
        }
        if (remaining < 1) {
            this.onComplete();
        }
    }

    private void onComplete() {
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderComplete(this);
        }
        this.unlockThread(DOWNLOAD_BLOCK);
    }

    private void waitForThreads() {
        boolean blocked;
        LOGGER.debug("Waiting for {} threads...", (Object)this.workingThreads);
        do {
            blocked = true;
            for (int i = 0; i < this.workingThreads; ++i) {
                if (this.threads[i].isThreadLocked()) continue;
                blocked = false;
            }
        } while (!blocked);
        LOGGER.debug("All threads are blocked by now");
    }
}

