/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.downloader;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import ru.turikhay.tlauncher.downloader.AbortedDownloadException;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.downloader.DownloadableHandler;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.U;

public class Downloadable {
    private static final boolean DEFAULT_FORCE = false;
    private static final boolean DEFAULT_FAST = false;
    private String path;
    private Repository repo;
    private File destination;
    private final List<File> additionalDestinations = Collections.synchronizedList(new ArrayList());
    private boolean forceDownload;
    private boolean fastDownload;
    private boolean insertUseragent;
    private boolean locked;
    private DownloadableContainer container;
    private final List<DownloadableHandler> handlers = Collections.synchronizedList(new ArrayList());
    private Throwable error;

    protected Downloadable() {
    }

    public Downloadable(Repository repo, String path, File destination, boolean forceDownload, boolean fastDownload) {
        this();
        this.setURL(repo, path);
        this.setDestination(destination);
        this.forceDownload = forceDownload;
        this.fastDownload = fastDownload;
    }

    public Downloadable(Repository repo, String path, File destination, boolean forceDownload) {
        this(repo, path, destination, forceDownload, false);
    }

    public Downloadable(Repository repo, String path, File destination) {
        this(repo, path, destination, false, false);
    }

    private Downloadable(String url, File destination, boolean forceDownload, boolean fastDownload) {
        this();
        this.setURL(url);
        this.setDestination(destination);
        this.forceDownload = forceDownload;
        this.fastDownload = fastDownload;
    }

    public Downloadable(String url, File destination) {
        this(url, destination, false, false);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Downloadable)) {
            return false;
        }
        Downloadable c = (Downloadable)o;
        return Objects.equals(this.path, c.path) && Objects.equals((Object)this.repo, (Object)c.repo) && Objects.equals(this.destination, c.destination) && Objects.equals(this.additionalDestinations, c.additionalDestinations);
    }

    public boolean getInsertUA() {
        return this.insertUseragent;
    }

    public void setInsertUA(boolean ua) {
        this.checkLocked();
        this.insertUseragent = ua;
    }

    public boolean isForce() {
        return this.forceDownload;
    }

    public void setForce(boolean force) {
        this.checkLocked();
        this.forceDownload = force;
    }

    public boolean isFast() {
        return this.fastDownload;
    }

    public void setFast(boolean fast) {
        this.checkLocked();
        this.fastDownload = fast;
    }

    public String getURL() {
        return this.path;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public boolean hasRepository() {
        return this.repo != null;
    }

    protected void setURL(Repository repo, String path) {
        if (repo == null) {
            throw new NullPointerException("repo");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.checkLocked();
        this.repo = repo;
        this.path = path;
    }

    protected void setURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        if (url.isEmpty()) {
            throw new IllegalArgumentException("URL cannot be empty!");
        }
        this.checkLocked();
        this.repo = null;
        this.path = url;
    }

    public File getDestination() {
        return this.destination;
    }

    public String getFilename() {
        return FileUtil.getFilename(this.path);
    }

    protected void setDestination(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.destination = file;
    }

    public List<File> getAdditionalDestinations() {
        return Collections.unmodifiableList(this.additionalDestinations);
    }

    public void addAdditionalDestination(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.additionalDestinations.add(file);
    }

    public DownloadableContainer getContainer() {
        return this.container;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public void addHandler(DownloadableHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.handlers.add(handler);
    }

    protected void setContainer(DownloadableContainer container) {
        this.checkLocked();
        this.container = container;
    }

    public Throwable getError() {
        return this.error;
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
    }

    protected void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Downloadable is locked!");
        }
    }

    protected void onStart() {
        this.setLocked(true);
        for (DownloadableHandler handler : this.handlers) {
            handler.onStart(this);
        }
    }

    protected void onAbort(AbortedDownloadException ae) {
        this.setLocked(false);
        this.error = ae;
        for (DownloadableHandler handler : this.handlers) {
            handler.onAbort(this);
        }
        if (this.container != null) {
            this.container.onAbort(this);
        }
    }

    protected void onComplete() throws RetryDownloadException {
        this.setLocked(false);
        for (DownloadableHandler handler : this.handlers) {
            handler.onComplete(this);
        }
        if (this.container != null) {
            this.container.onComplete(this);
        }
    }

    protected void onError(Throwable e) {
        this.error = e;
        if (e != null) {
            this.setLocked(false);
            for (DownloadableHandler handler : this.handlers) {
                handler.onError(this, e);
            }
            if (this.container != null) {
                this.container.onError(this, e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{path='" + this.path + "'; repo=" + (Object)((Object)this.repo) + "; destinations=" + this.destination + "," + this.additionalDestinations + "; force=" + this.forceDownload + "; fast=" + this.fastDownload + "; locked=" + this.locked + "; container=" + this.container + "; handlers=" + this.handlers + "; error=" + this.error + ";}";
    }

    public static HttpURLConnection setUp(URLConnection connection0, int timeout, boolean fake) {
        if (connection0 == null) {
            throw new NullPointerException();
        }
        if (!(connection0 instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("Unknown connection protocol: " + connection0);
        }
        HttpURLConnection connection = (HttpURLConnection)connection0;
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setRequestProperty("Expires", "0");
        return connection;
    }

    public static HttpURLConnection setUp(URLConnection connection, int timeout) {
        return Downloadable.setUp(connection, timeout, false);
    }

    public static HttpURLConnection setUp(URLConnection connection, boolean fake) {
        return Downloadable.setUp(connection, U.getConnectionTimeout(), fake);
    }

    public static HttpURLConnection setUp(URLConnection connection) {
        return Downloadable.setUp(connection, false);
    }

    public static String getEtag(String etag) {
        return etag == null ? "-" : (etag.startsWith("\"") && etag.endsWith("\"") ? etag.substring(1, etag.length() - 1) : etag);
    }
}

