/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.dbus.transport.junixsocket;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.AbstractUnixTransport;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;
import ru.turikhay.tlauncher.dbus.transport.junixsocket.UnixBusAddress;

public class JUnixSocketUnixTransport
extends AbstractUnixTransport {
    private final AFUNIXSocketAddress unixSocketAddress;
    private AFUNIXSocketChannel socket;
    private AFUNIXServerSocketChannel serverSocket;

    public JUnixSocketUnixTransport(UnixBusAddress address, TransportConfig transportConfig) throws TransportConfigurationException {
        super((BusAddress)address, transportConfig);
        if (!address.hasPath()) {
            throw new TransportConfigurationException("Native unix socket url has to specify 'path'");
        }
        try {
            this.unixSocketAddress = AFUNIXSocketAddress.of((Path)address.getPath());
        }
        catch (SocketException e) {
            throw new TransportConfigurationException("Unable to resolve unix socket address", (Throwable)e);
        }
    }

    protected boolean hasFileDescriptorSupport() {
        return AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_FILE_DESCRIPTORS);
    }

    protected SocketChannel connectImpl() throws IOException {
        if (this.getAddress().isListeningSocket()) {
            if (this.serverSocket == null || !this.serverSocket.isOpen()) {
                this.serverSocket = AFUNIXServerSocketChannel.open();
                this.serverSocket.bind((SocketAddress)this.unixSocketAddress);
            }
            this.socket = this.serverSocket.accept();
        } else {
            this.socket = AFUNIXSocketChannel.open((SocketAddress)this.unixSocketAddress);
        }
        this.socket.setAncillaryReceiveBufferSize(1024);
        this.socket.configureBlocking(true);
        return this.socket;
    }

    public void close() throws IOException {
        super.close();
        if (this.socket != null) {
            if (this.socket.isOpen()) {
                this.socket.close();
            }
            this.socket = null;
        }
        if (this.serverSocket != null) {
            if (this.serverSocket.isOpen()) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
    }

    public int getUid(SocketChannel sock) throws IOException {
        if (sock instanceof AFUNIXSocketExtensions) {
            AFUNIXSocketCredentials peerCredentials = ((AFUNIXSocketExtensions)sock).getPeerCredentials();
            return (int)peerCredentials.getUid();
        }
        throw new IllegalArgumentException("Unable to handle unknown socket type: " + sock.getClass());
    }

    protected boolean isAbstractAllowed() {
        return false;
    }
}

