/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.configuration.AbstractConfiguration;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.StringUtil;

public class SimpleConfiguration
implements AbstractConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Properties properties = new Properties();
    protected Object input;
    protected String comments;

    public SimpleConfiguration() {
    }

    public SimpleConfiguration(InputStream stream) throws IOException {
        this();
        SimpleConfiguration.loadFromStream(this.properties, stream);
        this.input = stream;
    }

    public SimpleConfiguration(File file) {
        this();
        try {
            SimpleConfiguration.loadFromFile(this.properties, file);
        }
        catch (Exception var3) {
            LOGGER.warn("Error loading config from file: {}", (Object)file, (Object)var3);
        }
        this.input = file;
    }

    public SimpleConfiguration(URL url) throws IOException {
        this();
        SimpleConfiguration.loadFromURL(this.properties, url);
        this.input = url;
    }

    @Override
    public String get(String key) {
        return this.getStringOf(this.properties.getProperty(key));
    }

    protected String getStringOf(Object obj) {
        String s;
        if (obj == null) {
            s = null;
        } else {
            s = obj.toString();
            if (s.isEmpty()) {
                s = null;
            }
        }
        return s;
    }

    public void set(String key, Object value, boolean flush) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value.toString());
        }
        if (flush && this.isSaveable()) {
            this.store();
        }
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, true);
    }

    public void set(Map<String, Object> map, boolean flush) {
        for (Map.Entry<String, Object> en : map.entrySet()) {
            String key = en.getKey();
            Object value = en.getValue();
            if (value == null) {
                this.properties.remove(key);
                continue;
            }
            this.properties.setProperty(key, value.toString());
        }
        if (flush && this.isSaveable()) {
            this.store();
        }
    }

    public void set(Map<String, Object> map) {
        this.set(map, false);
    }

    public Set<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        for (Object obj : this.properties.keySet()) {
            set.add(this.getStringOf(obj));
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public String getDefault(String key) {
        return null;
    }

    public int getInteger(String key, int def) {
        return this.getIntegerOf(this.get(key), 0);
    }

    @Override
    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    protected int getIntegerOf(Object obj, int def) {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (Exception var4) {
            return def;
        }
    }

    @Override
    public double getDouble(String key) {
        return this.getDoubleOf(this.get(key), 0.0);
    }

    protected double getDoubleOf(Object obj, double def) {
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (Exception var5) {
            return def;
        }
    }

    @Override
    public float getFloat(String key) {
        return this.getFloatOf(this.get(key), 0.0f);
    }

    protected float getFloatOf(Object obj, float def) {
        try {
            return Float.parseFloat(obj.toString());
        }
        catch (Exception var4) {
            return def;
        }
    }

    @Override
    public long getLong(String key) {
        return this.getLongOf(this.get(key), 0L);
    }

    protected long getLongOf(Object obj, long def) {
        try {
            return Long.parseLong(obj.toString());
        }
        catch (Exception var5) {
            return def;
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBooleanOf(this.get(key), false);
    }

    protected boolean getBooleanOf(Object obj, boolean def) {
        try {
            return StringUtil.parseBoolean(obj.toString());
        }
        catch (Exception var4) {
            return def;
        }
    }

    @Override
    public int getDefaultInteger(String key) {
        return 0;
    }

    @Override
    public double getDefaultDouble(String key) {
        return 0.0;
    }

    @Override
    public float getDefaultFloat(String key) {
        return 0.0f;
    }

    @Override
    public long getDefaultLong(String key) {
        return 0L;
    }

    @Override
    public boolean getDefaultBoolean(String key) {
        return false;
    }

    @Override
    public synchronized void save() throws IOException {
        if (!this.isSaveable()) {
            throw new UnsupportedOperationException();
        }
        Properties propsToSave = this.processSavingProperties(this.properties);
        File file = (File)this.input;
        File tmpFile = new File(file.getAbsolutePath() + ".tmp");
        FileUtil.createFile(tmpFile);
        try (FileOutputStream stream = new FileOutputStream(tmpFile);){
            propsToSave.store(stream, this.comments);
        }
        Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    protected Properties processSavingProperties(Properties og) {
        return og;
    }

    public void store() {
        try {
            this.save();
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't save configuration to {}", this.input, (Object)e);
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.get(String.valueOf(key));
    }

    @Override
    public String put(String key, String value) {
        this.set(key, value);
        return null;
    }

    @Override
    public String remove(Object key) {
        this.set(String.valueOf(key), null);
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
    }

    @Override
    public Collection<String> values() {
        return this.properties.values().stream().map(String::valueOf).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return null;
    }

    public boolean isSaveable() {
        return this.input != null && this.input instanceof File;
    }

    private static void loadFromStream(Properties properties, InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(stream), StandardCharsets.UTF_8);
        properties.clear();
        properties.load(reader);
    }

    static Properties loadFromStream(InputStream stream) throws IOException {
        Properties properties = new Properties();
        SimpleConfiguration.loadFromStream(properties, stream);
        return properties;
    }

    private static void loadFromFile(Properties properties, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        try (FileInputStream stream = new FileInputStream(file);){
            SimpleConfiguration.loadFromStream(properties, stream);
        }
    }

    protected static Properties loadFromFile(File file) throws IOException {
        Properties properties = new Properties();
        SimpleConfiguration.loadFromFile(properties, file);
        return properties;
    }

    private static void loadFromURL(Properties properties, URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException();
        }
        InputStream connection = url.openStream();
        SimpleConfiguration.loadFromStream(properties, connection);
    }

    protected static Properties loadFromURL(URL url) throws IOException {
        Properties properties = new Properties();
        SimpleConfiguration.loadFromURL(properties, url);
        return properties;
    }

    protected static void copyProperties(Properties src, Properties dest, boolean wipe) {
        if (src == null) {
            throw new NullPointerException("src is NULL");
        }
        if (dest == null) {
            throw new NullPointerException("dest is NULL");
        }
        if (wipe) {
            dest.clear();
        }
        for (Map.Entry<Object, Object> en : src.entrySet()) {
            String key = en.getKey() == null ? null : en.getKey().toString();
            String value = en.getKey() == null ? null : en.getValue().toString();
            dest.setProperty(key, value);
        }
    }

    protected static Properties copyProperties(Properties src) {
        Properties properties = new Properties();
        SimpleConfiguration.copyProperties(src, properties, false);
        return properties;
    }
}

