/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.SimpleConfiguration;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.U;

public final class LangConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Locale ru_RU = U.getLocale("ru_RU");
    private final Map<Locale, Properties> translationsMap = new HashMap<Locale, Properties>();
    private final Map<Locale, Pattern[]> pluralMap = new HashMap<Locale, Pattern[]>();
    private Pattern[] plurals;
    private Locale locale;
    private static final Lazy<List<Locale>> localeList = Lazy.of(() -> {
        List locales;
        block20: {
            URL url = LangConfiguration.class.getResource("/lang");
            if (url == null) {
                LOGGER.fatal("No available locales");
                return Collections.emptyList();
            }
            Function<Stream, List> locator = stream -> stream.map(it -> it.getFileName().toString()).filter(it -> it.startsWith("lang_") && it.endsWith(".properties")).map(it -> it.substring("lang_".length(), it.length() - ".properties".length()).replace('_', '-')).map(Locale::forLanguageTag).sorted(LocaleComparator.INSTANCE).collect(Collectors.toList());
            URI uri = url.toURI();
            if (uri.getScheme().equals("jar")) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap(), LangConfiguration.class.getClassLoader());
                     Stream<Path> stream2 = Files.walk(fs.getPath("/lang", new String[0]), 1, new FileVisitOption[0]).skip(1L);){
                    locales = locator.apply(stream2);
                    break block20;
                }
            }
            try (Stream<Path> stream3 = Files.walk(Paths.get(uri), 1, new FileVisitOption[0]).skip(1L);){
                locales = locator.apply(stream3);
            }
        }
        return Collections.unmodifiableList(locales);
    });

    public LangConfiguration() {
        this.setLocale(Locale.US);
    }

    public String lget(Locale locale, String key) {
        if (key == null) {
            return null;
        }
        if (this.translationsMap.containsKey(locale)) {
            Properties l = this.translationsMap.get(locale);
            return l.getProperty(key);
        }
        return null;
    }

    public String lget(Locale locale, String key, Object ... vars) {
        if (key == null) {
            return null;
        }
        String value = this.lget(locale, key);
        if (key.equals(value) || StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String[] variables = LangConfiguration.checkVariables(vars);
        if (this.pluralMap.containsKey(locale)) {
            Pattern[] plurals = this.pluralMap.get(locale);
            block0: for (int var = 0; var < variables.length; ++var) {
                String pluralReplacementValue = this.nget(key + '.' + var + ".plural");
                if (pluralReplacementValue == null) {
                    value = StringUtils.replace((String)value, (String)("%" + var), (String)variables[var]);
                    continue;
                }
                String[] pluralReplacements = StringUtils.split((String)pluralReplacementValue, (char)';');
                for (int patternKey = 0; patternKey < plurals.length; ++patternKey) {
                    if (!plurals[patternKey].matcher(variables[var]).matches()) continue;
                    value = StringUtils.replace((String)value, (String)("%" + var), (String)StringUtils.replace((String)pluralReplacements[patternKey], (String)"%n", (String)variables[var]));
                    continue block0;
                }
            }
        }
        return value;
    }

    public String nget(String key) {
        return this.lget(this.locale, key);
    }

    public String get(String key) {
        String value = this.nget(key);
        if (value == null) {
            value = this.lget(this.selectBackingLocale(), key);
        }
        return value == null ? key : value;
    }

    public String nget(String key, Object ... vars) {
        return this.lget(this.locale, key, vars);
    }

    public String get(String key, Object ... vars) {
        String value = this.nget(key, vars);
        if (value == null) {
            value = this.lget(this.selectBackingLocale(), key, vars);
        }
        return value == null ? key : value;
    }

    private Locale selectBackingLocale() {
        if (this.locale != ru_RU && Configuration.isLikelyRussianSpeakingLocale(this.locale.toString())) {
            this.loadLocale(ru_RU);
            return ru_RU;
        }
        return Locale.US;
    }

    private static String[] checkVariables(Object[] check) {
        if (check == null || check.length == 1 && check[0] == null) {
            return new String[0];
        }
        String[] string = new String[check.length];
        for (int i = 0; i < check.length; ++i) {
            string[i] = String.valueOf(check[i]);
        }
        return string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
        this.plurals = null;
        if (locale == null) {
            LOGGER.warn("Tried to set locale to null");
            return;
        }
        this.loadLocale(locale);
    }

    private synchronized void loadLocale(Locale locale) {
        Properties translations = this.getTranslations(locale);
        if (translations != null) {
            this.translationsMap.put(locale, translations);
            Pattern[] pluralPatterns = this.pluralMap.get(locale);
            if (pluralPatterns == null) {
                pluralPatterns = this.getPluralPatterns(locale);
                this.pluralMap.put(locale, pluralPatterns);
            }
            this.checkConsistancy(locale);
            this.plurals = pluralPatterns;
        }
    }

    private Properties getTranslations(Locale localeObj) {
        Properties translations;
        if (localeObj == null) {
            return null;
        }
        String localeStr = localeObj.toString();
        if (localeStr.equals("id_ID")) {
            localeStr = "in_ID";
        }
        if ((translations = this.translationsMap.get(localeObj)) == null) {
            try (InputStream in = LangConfiguration.class.getResourceAsStream("/lang/lang_" + localeStr + ".properties");){
                if (in == null) {
                    throw new NullPointerException("could not find translations for " + localeStr);
                }
                translations = SimpleConfiguration.loadFromStream(in);
            }
            catch (Exception e) {
                LOGGER.warn("Could not load translations for {}", (Object)localeStr, (Object)e);
                return null;
            }
        }
        return translations;
    }

    private Pattern[] getPluralPatterns(Locale locale) {
        Properties translations = this.getTranslations(locale);
        if (translations == null) {
            return null;
        }
        String pluralFormsRaw = translations.getProperty("plural");
        if (pluralFormsRaw == null) {
            LOGGER.warn("Plural forms not found: {}", (Object)locale);
            return null;
        }
        String[] pluralFormsSplit = StringUtils.split((String)pluralFormsRaw, (char)';');
        Pattern[] pluralForms = new Pattern[pluralFormsSplit.length];
        for (int i = 0; i < pluralForms.length; ++i) {
            try {
                pluralForms[i] = Pattern.compile(pluralFormsSplit[i]);
                continue;
            }
            catch (PatternSyntaxException sE) {
                throw new IllegalArgumentException("\"" + pluralFormsSplit[i] + "\" is not valid pattern; check plural forms for " + locale, sE);
            }
        }
        return pluralForms;
    }

    private void checkConsistancy(Locale locale) {
        if (TLauncher.getInstance() == null || !TLauncher.getInstance().isDebug() || locale == ru_RU) {
            return;
        }
        Properties translations = this.getTranslations(locale);
        if (translations == null) {
            return;
        }
        Properties ruTranslations = this.getTranslations(ru_RU);
        if (ruTranslations != null) {
            for (Object key : ruTranslations.keySet()) {
                if (translations.containsKey(key)) continue;
                LOGGER.warn("{} is missing key: {}", (Object)locale, key);
            }
            for (Object key : translations.keySet()) {
                if (ruTranslations.containsKey(key)) continue;
                LOGGER.warn("{} has redundant key: {}", (Object)locale, key);
            }
        }
    }

    public static List<Locale> getAvailableLocales() {
        return localeList.get();
    }

    private static class LocaleComparator
    implements Comparator<Locale> {
        public static final Comparator<Locale> INSTANCE = new LocaleComparator();

        private LocaleComparator() {
        }

        @Override
        public int compare(Locale o1, Locale o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

