/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.managers.GPUManager;
import ru.turikhay.tlauncher.ui.FlatLaf;
import ru.turikhay.util.Direction;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;

public final class ConfigurationDefaults {
    private static WeakReference<ConfigurationDefaults> ref;
    private static final int VERSION = 3;
    private final HashMap<String, Object> d = new HashMap();

    public static ConfigurationDefaults getInstance() {
        ConfigurationDefaults instance;
        if (ref == null || (instance = (ConfigurationDefaults)ref.get()) == null) {
            instance = new ConfigurationDefaults();
            ref = new WeakReference<ConfigurationDefaults>(instance);
        }
        return instance;
    }

    private ConfigurationDefaults() {
        this.d.put("settings.version", 3);
        this.d.put("minecraft.gamedir", MinecraftUtil.getDefaultWorkingDirectory().getAbsolutePath());
        this.d.put("minecraft.gamedir.separate", Configuration.SeparateDirs.NONE.name().toLowerCase(Locale.ROOT));
        this.d.put("minecraft.size", new IntegerArray(925, 530));
        this.d.put("minecraft.fullscreen", false);
        for (ReleaseType type : ReleaseType.getDefault()) {
            this.d.put("minecraft.versions." + type.name().toLowerCase(Locale.ROOT), true);
        }
        this.d.put("minecraft.versions.sub." + ReleaseType.SubType.REMOTE.name().toLowerCase(Locale.ROOT), true);
        this.d.put("minecraft.versions.sub." + ReleaseType.SubType.OLD_RELEASE.name().toLowerCase(Locale.ROOT), true);
        this.d.put("minecraft.versions.only-installed", false);
        this.d.put("minecraft.jre.type", "recommended");
        this.d.put("minecraft.javaargs", null);
        this.d.put("minecraft.args", null);
        this.d.put("minecraft.improvedargs", true);
        this.d.put("minecraft.gpu", GPUManager.GPU.DISCRETE.getName());
        if (OS.LINUX.isCurrent()) {
            this.d.put("minecraft.gamemode", true);
        }
        this.d.put("minecraft.xmx", "auto");
        this.d.put("minecraft.servers.promoted", true);
        this.d.put("minecraft.servers.promoted.ingame", true);
        this.d.put("minecraft.onlaunch", (Object)Configuration.ActionOnLaunch.HIDE);
        this.d.put("minecraft.crash", true);
        this.d.put("minecraft.deleteTlSkinCape", true);
        this.d.put("gui.font", OS.CURRENT == OS.WINDOWS ? 12 : 14);
        this.d.put("gui.size", new IntegerArray(OS.WINDOWS.isCurrent() ? 1000 : 1200, 600));
        this.d.putAll(FlatLaf.getDefaults());
        this.d.put("gui.background", null);
        this.d.put("gui.logger", (Object)Configuration.LoggerType.getDefault());
        this.d.put("gui.logger.width", 720);
        this.d.put("gui.logger.height", 500);
        this.d.put("gui.logger.x", 30);
        this.d.put("gui.logger.y", 30);
        this.d.put("gui.notices.enabled", true);
        this.d.put("notice.promoted", true);
        this.d.put("notice.enabled", true);
        this.d.put("gui.direction.loginform", (Object)Direction.CENTER);
        this.d.put("client", UUID.randomUUID());
        this.d.put("connection.ssl", true);
        this.d.put("ely.globally", true);
        if (OS.WINDOWS.isCurrent()) {
            this.d.put("windows.dxdiag", true);
            this.d.put("windows.gpuperf", true);
        }
        this.d.put("bootstrap.switchToBeta", false);
    }

    public static int getVersion() {
        return 3;
    }

    public Map<String, Object> getMap() {
        return Collections.unmodifiableMap(this.d);
    }

    public Object get(String key) {
        return this.d.get(key);
    }
}

