/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.versions.ReleaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.bootstrap.bridge.FlatLafConfiguration;
import ru.turikhay.tlauncher.configuration.ArgumentParser;
import ru.turikhay.tlauncher.configuration.Configurable;
import ru.turikhay.tlauncher.configuration.ConfigurationDefaults;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.configuration.PlainParser;
import ru.turikhay.tlauncher.configuration.SimpleConfiguration;
import ru.turikhay.tlauncher.ui.FlatLaf;
import ru.turikhay.util.Direction;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.U;

public class Configuration
extends SimpleConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private ConfigurationDefaults defaults;
    private ArgumentParser.ParsedConfigEntryMap configFromArgs;
    private boolean firstRun;
    private final boolean externalLocation;
    private final Version zeroVersion = Version.forIntegers((int)0, (int)0, (int)0);

    private Configuration(URL url, OptionSet set) throws IOException {
        super(url);
        this.externalLocation = true;
        this.init(set);
    }

    private Configuration(File file, OptionSet set) {
        super(file);
        this.externalLocation = !file.equals(Configuration.getDefaultFile());
        this.init(set);
    }

    public static Configuration createConfiguration(OptionSet set) throws IOException {
        boolean doesntExist;
        File file;
        Object path;
        Object object = path = set != null ? set.valueOf("settings") : null;
        if (path == null) {
            file = FileUtil.getNeighborFile("tlauncher.cfg");
            if (!file.isFile()) {
                file = FileUtil.getNeighborFile("tlauncher.properties");
            }
            if (!file.isFile()) {
                file = Configuration.getDefaultFile();
            }
        } else {
            LOGGER.debug("--settings argument: {}", path);
            file = new File(path.toString());
        }
        boolean bl = doesntExist = !file.isFile();
        if (doesntExist) {
            LOGGER.debug("Creating file: {}", (Object)file);
            FileUtil.createFile(file);
        }
        LOGGER.info("Reading configuration from: {}", (Object)file);
        Configuration config = new Configuration(file, set);
        if (doesntExist) {
            config.firstRun = true;
        } else if (config.getBoolean("firstRun")) {
            config.firstRun = true;
            config.set("firstRun", null);
        }
        return config;
    }

    private void init(OptionSet set) {
        String separateDirsValue;
        this.comments = " Legacy Launcher " + TLauncher.getBrand() + " properties\n Created in " + TLauncher.getVersion();
        this.defaults = ConfigurationDefaults.getInstance();
        this.configFromArgs = ArgumentParser.extractConfigEntries(set);
        if (this.getDouble("settings.version") != (double)ConfigurationDefaults.getVersion()) {
            LOGGER.warn("Configuration is being wiped due to version incapability");
            this.set("settings.version", ConfigurationDefaults.getVersion(), false);
            this.clear();
        }
        LOGGER.debug("Config entries from args: {}", (Object)this.configFromArgs);
        this.configFromArgs.entries().forEach((? super T c) -> this.setForcefully(c.getPath(), c.getValue(), false));
        if (this.externalLocation && !Objects.equals(TLauncher.getInstance().getPackageMode().orElse(null), "flatpak")) {
            LOGGER.debug("Using configuration from an external location");
            File defFile = Configuration.getDefaultFile();
            SimpleConfiguration backConfig = new SimpleConfiguration(defFile);
            if (!defFile.isFile()) {
                LOGGER.debug("Default file doesn't exist, oops...");
                backConfig.set("settings.version", ConfigurationDefaults.getVersion());
                backConfig.set("client", UUID.randomUUID());
                backConfig.store();
            }
            this.set("client", backConfig.get("client"), false);
        }
        try {
            UUID.fromString(this.get("client"));
        }
        catch (RuntimeException rE) {
            LOGGER.debug("Recreating UUID...");
            this.set("client", UUID.randomUUID(), false);
        }
        LOGGER.info("UUID: {}", (Object)this.getClient());
        for (Map.Entry<String, Object> defEntry : this.defaults.getMap().entrySet()) {
            if (this.configFromArgs.isConstant(defEntry.getKey())) continue;
            String value = this.get(defEntry.getKey());
            try {
                PlainParser.parse(this.get(defEntry.getKey()), defEntry.getValue());
            }
            catch (RuntimeException rE) {
                LOGGER.warn("Could not parse {}, got: {}", (Object)defEntry.getKey(), (Object)value);
                this.set(defEntry.getKey(), defEntry.getValue(), false);
            }
        }
        Locale locale = U.getLocale(this.get("locale"));
        if (locale == null) {
            LOGGER.warn("Locale is not supported by Java: {}", (Object)this.get("locale"));
            LOGGER.warn("May be system default?");
            locale = Locale.getDefault();
        }
        if (!LangConfiguration.getAvailableLocales().contains(locale)) {
            LOGGER.debug("We don't have localization for {}", (Object)locale);
            locale = Configuration.isLikelyRussianSpeakingLocale(locale.toString()) && LangConfiguration.getAvailableLocales().contains(LangConfiguration.ru_RU) ? LangConfiguration.ru_RU : Locale.US;
            LOGGER.debug("Selecting {}", (Object)locale);
        }
        this.set("locale", locale);
        int oldFontSize = this.getInteger("gui.font.old");
        if (oldFontSize == 0) {
            this.set("gui.font.old", this.getInteger("gui.font"));
        }
        if ("false".equals(separateDirsValue = this.get("minecraft.gamedir.separate")) || "true".equals(separateDirsValue)) {
            this.setSeparateDirs(this.getBoolean("minecraft.gamedir.separate") ? SeparateDirs.FAMILY : SeparateDirs.NONE);
        }
        LOGGER.debug("Using configuration: {}", (Object)this.properties);
        if (this.isSaveable()) {
            try {
                this.save();
            }
            catch (IOException ioE) {
                LOGGER.warn("Couldn't save config", (Throwable)ioE);
            }
        }
    }

    public boolean isCertFixed() {
        return !this.getBoolean("connection.ssl");
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public boolean isSaveable(String key) {
        return !this.configFromArgs.isConstant(key);
    }

    public Locale getLocale() {
        return U.getLocale(this.get("locale"));
    }

    public boolean isLikelyRussianSpeakingLocale() {
        return Configuration.isLikelyRussianSpeakingLocale(this.getLocale().toString());
    }

    public ActionOnLaunch getActionOnLaunch() {
        return ActionOnLaunch.find(this.get("minecraft.onlaunch")).orElse(ActionOnLaunch.getDefault());
    }

    public LoggerType getLoggerType() {
        return LoggerType.get(this.get("gui.logger"));
    }

    public void setLoggerType(LoggerType loggerType) {
        this.set("gui.logger", loggerType.toString());
    }

    public SeparateDirs getSeparateDirs() {
        return SeparateDirs.get(this.get("minecraft.gamedir.separate"));
    }

    public void setSeparateDirs(SeparateDirs separateDirs) {
        this.set("minecraft.gamedir.separate", separateDirs.toString().toLowerCase(Locale.ROOT));
    }

    public int[] getClientWindowSize() {
        String plainValue = this.get("minecraft.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(plainValue);
            value[0] = arr.get(0);
            value[1] = arr.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getLauncherWindowSize() {
        String plainValue = this.get("gui.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(plainValue);
            value[0] = arr.get(0);
            value[1] = arr.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getDefaultClientWindowSize() {
        String plainValue = this.getDefault("minecraft.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public int[] getDefaultLauncherWindowSize() {
        String plainValue = this.getDefault("gui.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public VersionFilter getVersionFilter() {
        VersionFilter filter = new VersionFilter();
        for (ReleaseType type : ReleaseType.getDefinable()) {
            boolean include = this.getBoolean("minecraft.versions." + (Object)((Object)type));
            if (include) continue;
            filter.exclude(type);
        }
        for (ReleaseType.SubType var7 : ReleaseType.SubType.values()) {
            boolean include1 = this.getBoolean("minecraft.versions.sub." + (Object)((Object)var7));
            if (include1) continue;
            filter.exclude(var7);
        }
        return filter;
    }

    public Direction getDirection(String key) {
        return Direction.parse(this.get(key));
    }

    public Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public UUID getClient() {
        try {
            return UUID.fromString(this.get("client"));
        }
        catch (Exception var2) {
            return this.refreshClient();
        }
    }

    public UUID refreshClient() {
        UUID newId = UUID.randomUUID();
        this.set("client", newId);
        return newId;
    }

    public Version getVersion(String path) {
        try {
            return Version.valueOf((String)this.get(path));
        }
        catch (RuntimeException rE) {
            return this.zeroVersion;
        }
    }

    public boolean isUsingSystemLookAndFeel() {
        return this.getBoolean("gui.systemlookandfeel");
    }

    public void setUsingSystemLookAndFeel(boolean use) {
        this.set("gui.systemlookandfeel", use, false);
    }

    public float getFontSize() {
        return this.getFloat("gui.font");
    }

    @Override
    public String getDefault(String key) {
        return this.getStringOf(this.defaults.get(key));
    }

    @Override
    public int getDefaultInteger(String key) {
        return this.getIntegerOf(this.defaults.get(key), 0);
    }

    @Override
    public double getDefaultDouble(String key) {
        return this.getDoubleOf(this.defaults.get(key), 0.0);
    }

    @Override
    public float getDefaultFloat(String key) {
        return this.getFloatOf(this.defaults.get(key), 0.0f);
    }

    @Override
    public long getDefaultLong(String key) {
        return this.getLongOf(this.defaults.get(key), 0L);
    }

    @Override
    public boolean getDefaultBoolean(String key) {
        return this.getBooleanOf(this.defaults.get(key), false);
    }

    @Override
    public void set(String key, Object value, boolean flush) {
        if (!this.configFromArgs.isConstant(key)) {
            super.set(key, value, flush);
        }
    }

    public void setForcefully(String key, Object value, boolean flush) {
        super.set(key, value, flush);
    }

    public void setForcefully(String key, Object value) {
        this.setForcefully(key, value, true);
    }

    @Override
    protected Properties processSavingProperties(Properties og) {
        Properties temp = Configuration.copyProperties(this.properties);
        for (String constant : this.configFromArgs.constants()) {
            temp.remove(constant);
        }
        return temp;
    }

    public <C extends Configurable> C get(Class<C> configurable) {
        Configurable c;
        try {
            c = (Configurable)configurable.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        c.load(this);
        return (C)c;
    }

    public <C extends Configurable> void set(C configurable) {
        configurable.save(this);
    }

    public Optional<FlatLafConfiguration> getFlatLafConfiguration() {
        return FlatLaf.parseFromMap(this);
    }

    public void setFlatLafConfiguration(Object configuration) {
        if (!(configuration instanceof FlatLafConfiguration)) {
            throw new IllegalArgumentException();
        }
        this.putAll(((FlatLafConfiguration)configuration).toMap());
    }

    public File getFile() {
        return !this.isSaveable() ? null : (File)this.input;
    }

    public static boolean isLikelyRussianSpeakingLocale(String l) {
        return "ru_RU".equals(l) || "uk_UA".equals(l) || "be_BY".equals(l);
    }

    private static File getDefaultFile() {
        return MinecraftUtil.getSystemRelatedDirectory(TLauncher.getSettingsFile());
    }

    public static enum SeparateDirs {
        FAMILY,
        VERSION,
        NONE;


        public static boolean parse(String val) {
            if (val != null) {
                for (SeparateDirs cur : SeparateDirs.values()) {
                    if (!cur.toString().equalsIgnoreCase(val)) continue;
                    return true;
                }
                return val.equals("true") || val.equals("false");
            }
            return false;
        }

        public static SeparateDirs get(String val) {
            for (SeparateDirs cur : SeparateDirs.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return cur;
            }
            return null;
        }
    }

    public static enum ActionOnLaunch {
        HIDE,
        EXIT,
        NOTHING;


        @Nonnull
        public static Optional<ActionOnLaunch> find(@Nullable String name) {
            if (name == null) {
                return Optional.empty();
            }
            return Arrays.stream(ActionOnLaunch.values()).filter(it -> it.toString().equalsIgnoreCase(name)).findAny();
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static ActionOnLaunch getDefault() {
            return HIDE;
        }
    }

    public static enum LoggerType {
        GLOBAL,
        NONE;


        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            for (LoggerType cur : LoggerType.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }

        public static LoggerType get(String val) {
            for (LoggerType cur : LoggerType.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return cur;
            }
            return null;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static LoggerType getDefault() {
            return NONE;
        }
    }
}

