/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.minecraft.PromotedServer;
import ru.turikhay.tlauncher.minecraft.PromotedServerDeserializer;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeDeserializer;
import ru.turikhay.tlauncher.ui.notification.UrlNotificationObject;

public final class BootConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean stats;
    private boolean ely;
    private final Map<String, List<String>> repositories = new HashMap<String, List<String>>();
    private final Map<String, List<Notice>> notices = new HashMap<String, List<Notice>>();
    private final Map<String, List<PromotedServer>> promotedServers = new HashMap<String, List<PromotedServer>>();
    private final Map<String, List<PromotedServer>> outdatedPromotedServers = new HashMap<String, List<PromotedServer>>();
    private final Map<String, String> feedback = new HashMap<String, String>();
    private final Map<String, UrlNotificationObject> notifications = new HashMap<String, UrlNotificationObject>();
    private int allowNoticeDisable;

    public boolean isStatsAllowed() {
        return this.stats;
    }

    public boolean isElyAllowed() {
        return this.ely;
    }

    public Map<String, List<String>> getRepositories() {
        return this.repositories;
    }

    public Map<String, List<Notice>> getNotices() {
        return this.notices;
    }

    public Map<String, List<PromotedServer>> getPromotedServers() {
        return this.promotedServers;
    }

    public Map<String, List<PromotedServer>> getOutdatedPromotedServers() {
        return this.outdatedPromotedServers;
    }

    public Map<String, String> getFeedback() {
        return this.feedback;
    }

    public Map<String, UrlNotificationObject> getNotifications() {
        return this.notifications;
    }

    public boolean isAllowNoticeDisable(UUID userId) {
        return this.allowNoticeDisable > 0 && userId.hashCode() % this.allowNoticeDisable == 0;
    }

    public int getAllowNoticeDisable() {
        return this.allowNoticeDisable;
    }

    public static BootConfiguration parse(String options) {
        Objects.requireNonNull(options, "options");
        Gson gson = new GsonBuilder().registerTypeAdapter(Notice.class, (Object)new NoticeDeserializer()).registerTypeAdapter(PromotedServer.class, (Object)new PromotedServerDeserializer()).create();
        return (BootConfiguration)gson.fromJson(options, BootConfiguration.class);
    }
}

