/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.OS;

public class ArgumentParser {
    private static final Map<String, Arg> argMap = new LinkedHashMap<String, Arg>();

    public static OptionSet parseArgs(String[] args) {
        OptionParser parser = ArgumentParser.createParser();
        return parser.parse(args);
    }

    public static String printHelp() {
        OptionParser parser = ArgumentParser.createParser();
        StringWriter writer = new StringWriter();
        try {
            parser.printHelpOn((Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        writer.flush();
        return writer.toString();
    }

    public static ParsedConfigEntryMap extractConfigEntries(OptionSet set) {
        LinkedHashMap<String, ParsedConfigEntry> entries = new LinkedHashMap<String, ParsedConfigEntry>();
        if (set.has("java-directory") && !set.has("java-executable")) {
            ConfigAttachment cfa = (ConfigAttachment)ArgumentParser.argMap.get((Object)"java-executable").attachment;
            entries.put(cfa.path, new ParsedConfigEntry(cfa, set.valueOf("java-directory") + File.pathSeparator + "bin" + File.pathSeparator + "java" + (OS.WINDOWS.isCurrent() ? "w.exe" : "")));
        }
        for (Arg arg : argMap.values()) {
            if (!(arg.attachment instanceof ConfigAttachment)) continue;
            ConfigAttachment cfa = (ConfigAttachment)arg.attachment;
            if (!set.has(arg.name)) continue;
            Object value = arg.needsArg ? set.valueOf(arg.name) : Boolean.TRUE;
            entries.put(cfa.path, new ParsedConfigEntry(cfa, String.valueOf(value)));
        }
        return new ParsedConfigEntryMap(entries);
    }

    private static OptionParser createParser() {
        OptionParser parser = new OptionParser();
        for (Arg arg : argMap.values()) {
            OptionSpecBuilder b = parser.accepts(arg.name, arg.description);
            if (!arg.needsArg) continue;
            b.withRequiredArg();
        }
        return parser;
    }

    private static void addConfig(String name, @Nullable String path, String description, boolean needsArg) {
        Arg arg = new Arg(name, description, new ConfigAttachment(path, true));
        arg.needsArg = needsArg;
        argMap.put(name, arg);
    }

    private static void addConfig(String name, @Nullable String path, String description) {
        ArgumentParser.addConfig(name, path, description, true);
    }

    private static Arg add(String name, String description) {
        Arg arg = new Arg(name, description, null);
        argMap.put(name, arg);
        return arg;
    }

    private static void addIgnored(String name) {
        argMap.put(name, new Arg(name, "Deprecated & ignored", new IgnoredArgAttachment(name)));
    }

    static {
        ArgumentParser.add("help", "Prints help");
        ArgumentParser.add("debug", "Prints help");
        ArgumentParser.add("settings", "Specifies path to settings file").needsArg();
        ArgumentParser.addIgnored("no-gui");
        ArgumentParser.addIgnored("no-terminate");
        ArgumentParser.addConfig("directory", "minecraft.gamedir", "Specifies Minecraft directory");
        ArgumentParser.addIgnored("profiles");
        ArgumentParser.addConfig("java-executable", "minecraft.cmd", "Specifies Java executable");
        ArgumentParser.add("java-directory", "Deprecated. Specifies Java directory. Use java-executable instead").needsArg();
        ArgumentParser.addConfig("version", "login.version", "Specifies Minecraft version to run");
        ArgumentParser.add("username", "Specifies name of the user to select").needsArg();
        ArgumentParser.add("usertype", "Specifies type of the user to select (in case there are multiple of them)").needsArg();
        ArgumentParser.addConfig("javaargs", "minecraft.javaargs", "Specifies JVM arguments");
        ArgumentParser.addConfig("margs", "minecraft.args", "Specifies Minecraft arguments");
        ArgumentParser.addConfig("window", "minecraft.size", "Specifies window size in format: width;height");
        ArgumentParser.addConfig("background", "gui.background", "Specifies background image");
        ArgumentParser.addConfig("fullscreen", "minecraft.fullscreen", "Specifies whether fullscreen mode enabled or not");
        ArgumentParser.addConfig("theme", "gui.theme", "Specifies theme file");
        ArgumentParser.addConfig("jre-dir", "minecraft.jre.dir", "Specifies where Mojang JRE is saved");
        ArgumentParser.addConfig("launch", "login.auto", "Specifies whether to launch Minecraft automatically", false);
        ArgumentParser.addIgnored("block-settings");
    }

    private static class Arg {
        final String name;
        final String description;
        @Nullable
        final Attachment attachment;
        boolean needsArg;

        Arg(String name, String description, @Nullable Attachment attachment) {
            this.name = name;
            this.description = description;
            this.attachment = attachment;
        }

        Arg needsArg() {
            this.needsArg = true;
            return this;
        }
    }

    private static interface Attachment {
    }

    private static class ConfigAttachment
    implements Attachment {
        final String path;
        final boolean constant;

        ConfigAttachment(String path, boolean constant) {
            this.path = path;
            this.constant = constant;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigAttachment that = (ConfigAttachment)o;
            return this.constant == that.constant && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.constant);
        }
    }

    public static class ParsedConfigEntry {
        private final ConfigAttachment attachment;
        @Nullable
        private final String value;

        private ParsedConfigEntry(ConfigAttachment attachment, @Nullable String value) {
            this.attachment = attachment;
            this.value = value;
        }

        public String getPath() {
            return this.attachment.path;
        }

        public boolean isConstant() {
            return this.attachment.constant;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParsedConfigEntry that = (ParsedConfigEntry)o;
            return this.attachment.equals(that.attachment) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.attachment, this.value);
        }

        public String toString() {
            return "{key=" + this.attachment.path + ",value=" + this.value + ",constant=" + this.attachment.constant + "}";
        }
    }

    public static class ParsedConfigEntryMap {
        private final Map<String, ParsedConfigEntry> entryMap;
        private final Set<String> constants;

        ParsedConfigEntryMap(Map<String, ParsedConfigEntry> entryMap) {
            this.entryMap = entryMap;
            this.constants = entryMap.values().stream().filter(ParsedConfigEntry::isConstant).map(e -> ((ParsedConfigEntry)e).attachment.path).collect(Collectors.toSet());
        }

        public Optional<ParsedConfigEntry> getByKey(String key) {
            return Optional.ofNullable(this.entryMap.get(key));
        }

        public Collection<ParsedConfigEntry> entries() {
            return this.entryMap.values();
        }

        public boolean contains(String key) {
            return this.entryMap.containsKey(key);
        }

        public Collection<String> constants() {
            return this.constants;
        }

        public boolean isConstant(String key) {
            return this.constants.contains(key);
        }

        public String toString() {
            return "ParsedConfigEntryMap{entryMap=" + this.entryMap + '}';
        }
    }

    private static class IgnoredArgAttachment
    implements ActionAttachment {
        private static final Logger LOGGER = LogManager.getLogger(IgnoredArgAttachment.class);
        final String name;

        public IgnoredArgAttachment(String name) {
            this.name = name;
        }

        @Override
        public void execute() {
            LOGGER.warn("Argument {} is ignored", (Object)this.name);
        }
    }

    private static interface ActionAttachment
    extends Attachment {
        public void execute();
    }
}

