/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.component;

import java.util.Arrays;
import java.util.concurrent.Semaphore;
import ru.turikhay.tlauncher.component.RefreshableComponent;
import ru.turikhay.tlauncher.managers.ComponentManager;

public abstract class InterruptibleComponent
extends RefreshableComponent {
    protected final boolean[] refreshList;
    private int lastRefreshID;
    protected final Semaphore semaphore = new Semaphore(1);
    protected boolean lastResult;

    protected InterruptibleComponent(ComponentManager manager) {
        this(manager, 64);
    }

    private InterruptibleComponent(ComponentManager manager, int listSize) {
        super(manager);
        if (listSize < 1) {
            throw new IllegalArgumentException("Invalid list size: " + listSize + " < 1");
        }
        this.refreshList = new boolean[listSize];
    }

    @Override
    public final boolean refresh() {
        if (this.semaphore.tryAcquire()) {
            boolean var2;
            try {
                var2 = this.lastResult = this.refresh(this.nextID());
            }
            finally {
                this.semaphore.release();
            }
            return var2;
        }
        try {
            this.semaphore.acquire();
            boolean var2 = this.lastResult;
            return var2;
        }
        catch (InterruptedException var11) {
            var11.printStackTrace();
        }
        finally {
            this.semaphore.release();
        }
        return false;
    }

    public final boolean isRefreshing() {
        return this.semaphore.hasQueuedThreads();
    }

    public synchronized void stopRefresh() {
        Arrays.fill(this.refreshList, false);
    }

    protected synchronized int nextID() {
        int next;
        int listSize = this.refreshList.length;
        if ((next = this.lastRefreshID++) >= listSize) {
            next = 0;
        }
        this.lastRefreshID = next;
        return next;
    }

    protected boolean isCancelled(int refreshID) {
        return !this.refreshList[refreshID];
    }

    protected abstract boolean refresh(int var1);
}

