/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher;

import com.github.zafarkhaja.semver.Version;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import joptsimple.OptionSet;
import net.legacylauncher.LegacyLauncher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.slf4j.spi.SLF4JServiceProvider;
import ru.turikhay.tlauncher.bootstrap.bridge.BootBridge;
import ru.turikhay.tlauncher.bootstrap.bridge.BootEventDispatcher;
import ru.turikhay.tlauncher.bootstrap.bridge.BootMessage;
import ru.turikhay.tlauncher.bootstrap.bridge.FlatLafConfiguration;
import ru.turikhay.tlauncher.configuration.ArgumentParser;
import ru.turikhay.tlauncher.configuration.BootConfiguration;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.configuration.Static;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.logger.Log4j2ContextHelper;
import ru.turikhay.tlauncher.logger.LoggerBuffer;
import ru.turikhay.tlauncher.logger.LoggerInterface;
import ru.turikhay.tlauncher.logger.SwingLoggerAppender;
import ru.turikhay.tlauncher.managers.AuthServerChecker;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ComponentManagerListenerHelper;
import ru.turikhay.tlauncher.managers.ConnectivityManager;
import ru.turikhay.tlauncher.managers.GPUManager;
import ru.turikhay.tlauncher.managers.JavaManager;
import ru.turikhay.tlauncher.managers.JavaManagerConfig;
import ru.turikhay.tlauncher.managers.LibraryReplaceProcessor;
import ru.turikhay.tlauncher.managers.MemoryAllocationService;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.PromotedStoreManager;
import ru.turikhay.tlauncher.managers.SwitcherooControlGPUManager;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.WindowsGpuManager;
import ru.turikhay.tlauncher.minecraft.PromotedServer;
import ru.turikhay.tlauncher.minecraft.Server;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncher;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.sentry.SentryConfigurer;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.FlatLaf;
import ru.turikhay.tlauncher.ui.LLaunchFrame;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.frames.FirstRunNotice;
import ru.turikhay.tlauncher.ui.frames.NewFolderFrame;
import ru.turikhay.tlauncher.ui.frames.UpdateFrame;
import ru.turikhay.tlauncher.ui.listener.UIListeners;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.logger.SwingLogger;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.notification.Notification;
import ru.turikhay.tlauncher.user.PlainUser;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;
import ru.turikhay.util.logging.DelegateServiceProvider;

public final class TLauncher {
    private static final Logger LOGGER = LogManager.getLogger(LegacyLauncher.class);
    private final boolean debug;
    private final boolean ready;
    private final BootBridge bridge;
    private final BootEventDispatcher dispatcher;
    private final BootConfiguration bootConfig;
    private final boolean bootConfigEmpty;
    private final Configuration config;
    private final LangConfiguration lang;
    private SwingLogger loggerUI;
    private final ComponentManager componentManager;
    private final LibraryReplaceProcessor libraryReplaceManager;
    private final VersionManager versionManager;
    private final ProfileManager profileManager;
    private final JavaManager javaManager;
    private final ConnectivityManager connectivityManager;
    private final MemoryAllocationService memoryAllocationService;
    private final GPUManager gpuManager;
    private final PromotedStoreManager promotedStoreManager;
    private final Downloader downloader;
    private final UIListeners uiListeners;
    private TLauncherFrame frame;
    private final long sessionStartTime;
    private final Object onReadySync = new Object();
    private Queue<Runnable> onReadyJobs = new ConcurrentLinkedQueue<Runnable>();
    private static final String PONG_RESPONSE = "Pong!\n";
    private static final String LAUNCHERMETA = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private ConnectivityManager.Entry authServerCheckEntry;
    private ConnectivityManager.Entry elyByCheckEntry;
    private MinecraftLauncher launcher;
    private boolean reportsCapabilities;
    private static TLauncher instance;
    private static final Version SEMVER;

    private TLauncher(BootBridge bridge, BootEventDispatcher dispatcher) throws Exception {
        Optional<String> packageModeOpt;
        BootConfiguration bootConfig;
        Objects.requireNonNull(bridge, "bridge");
        TLauncher.checkNotRunning();
        instance = this;
        Object timer = new Object();
        Time.start(timer);
        this.bridge = bridge;
        this.checkReportsCapabilities();
        this.getCapability("slf4jDelegateServiceProvider", DelegateServiceProvider.class).ifPresent(delegateServiceProvider -> delegateServiceProvider.setProvider((SLF4JServiceProvider)new org.apache.logging.slf4j.SLF4JServiceProvider()));
        this.dispatcher = dispatcher;
        LOGGER.debug("Options: {}", bridge.getOptions() == null ? null : bridge.getOptions().length() + " code units");
        OptionSet optionSet = ArgumentParser.parseArgs(bridge.getArgs());
        if (optionSet.has("help")) {
            LOGGER.info("\n{}", (Object)ArgumentParser.printHelp());
            System.exit(0);
        }
        this.debug = optionSet.has("debug");
        dispatcher.onBootStateChanged("Loading configuration", 0.1);
        this.config = Configuration.createConfiguration(optionSet);
        dispatcher.passClient(this.config.getClient());
        this.migrateLafConfigOrSetLaf();
        this.lang = new LangConfiguration();
        this.initConfig();
        SwingUtil.wait(this::reloadLoggerUI);
        boolean bootConfigEmpty = false;
        try {
            bootConfig = BootConfiguration.parse(bridge.getOptions());
        }
        catch (RuntimeException rE) {
            LOGGER.warn("Couldn't parse boot config: {}", (Object)bridge.getOptions(), (Object)rE);
            bootConfig = new BootConfiguration();
            bootConfigEmpty = true;
        }
        this.bootConfig = bootConfig;
        this.bootConfigEmpty = bootConfigEmpty;
        Repository.updateList(bootConfig.getRepositories());
        Stats.setAllowed(bootConfig.isStatsAllowed());
        dispatcher.onBootStateChanged("Handling run conditions", 0.17);
        this.handleWorkdir();
        if (!this.config.isFirstRun()) {
            this.handleUpdate();
        }
        this.handleNoticeHiding();
        dispatcher.onBootStateChanged("Preparing managers", 0.2);
        this.componentManager = new ComponentManager(this);
        dispatcher.onBootStateChanged("Loading Library Replace manager", 0.22);
        this.libraryReplaceManager = this.componentManager.loadComponent(LibraryReplaceProcessor.class);
        this.libraryReplaceManager.setAllowElyEverywhere(bootConfig.isElyAllowed());
        dispatcher.onBootStateChanged("Loading Version manager", 0.27);
        this.versionManager = this.componentManager.loadComponent(VersionManager.class);
        dispatcher.onBootStateChanged("Loading Profile manager", 0.35);
        this.profileManager = this.componentManager.loadComponent(ProfileManager.class);
        this.migrateFromOldJreConfig();
        File jreRootDir = new File(this.config.get(JavaManagerConfig.class).getRootDirOrDefault());
        FileUtil.createFolder(jreRootDir);
        this.javaManager = new JavaManager(jreRootDir);
        this.connectivityManager = this.initConnectivityManager();
        this.connectivityManager.queueChecks();
        this.memoryAllocationService = new MemoryAllocationService();
        this.migrateMemoryValue();
        dispatcher.onBootStateChanged("Loading manager listener", 0.36);
        this.componentManager.loadComponent(ComponentManagerListenerHelper.class);
        dispatcher.onBootStateChanged("Loading Downloader", 0.4);
        this.downloader = new Downloader();
        dispatcher.onBootStateChanged("Loading UI Listeners", 0.5);
        this.uiListeners = new UIListeners(this);
        SwingUtil.wait(() -> {
            dispatcher.onBootStateChanged("Loading frame", 0.65);
            this.frame = new TLauncherFrame(this);
            dispatcher.onBootStateChanged("Post-init UI", 0.8);
            this.initAndRefreshUI();
        });
        this.ready = true;
        this.sessionStartTime = System.currentTimeMillis();
        dispatcher.onBootSucceeded();
        if (this.config.getClient().toString().equals("23a9e755-046a-4250-9e03-1920baa98aeb")) {
            this.config.set("client", UUID.randomUUID());
        }
        this.gpuManager = OS.LINUX.isCurrent() ? SwitcherooControlGPUManager.Loader.tryToCreate().orElse(GPUManager.Empty.INSTANCE) : (OS.WINDOWS.isCurrent() ? WindowsGpuManager.tryToCreate().orElse(GPUManager.Empty.INSTANCE) : GPUManager.Empty.INSTANCE);
        LOGGER.info("Loaded GPU manager: {}", (Object)this.gpuManager);
        this.promotedStoreManager = new PromotedStoreManager();
        this.preloadUI();
        if (this.elyByCheckEntry != null && this.profileManager.getAccountManager().getUserSet().getSet().stream().anyMatch(u -> u.getType().equals("ely"))) {
            this.elyByCheckEntry.withPriority(500);
            this.connectivityManager.queueCheck(this.elyByCheckEntry);
        }
        if (this.authServerCheckEntry != null) {
            if (this.profileManager.getAccountManager().getUserSet().getSet().stream().anyMatch(u -> u.getType().equals("mojang") || u.getType().equals("minecraft"))) {
                this.bumpAuthServerCheckPriority();
            } else {
                this.authServerCheckEntry.getTask().thenRun(() -> {
                    AuthServerChecker checker = (AuthServerChecker)this.authServerCheckEntry.getChecker();
                    if (checker.getDetectedThirdPartyAuthenticator() != null) {
                        this.bumpAuthServerCheckPriority();
                    }
                });
            }
            this.connectivityManager.queueCheck(this.authServerCheckEntry);
        }
        if ((packageModeOpt = this.getPackageMode()).filter(m -> m.equals("dmg")).isPresent()) {
            Optional<String> dmgAppPathOpt = this.getCapability("dmg-app-path", String.class);
            if (!dmgAppPathOpt.isPresent()) {
                LOGGER.warn("Package mode is dmg, but bootstrap hasn't announced dmg-app-path");
            } else {
                String dmgAppPath = dmgAppPathOpt.get();
                if (dmgAppPath.startsWith("/Volumes/")) {
                    LOGGER.info("Application seems to be running from a .dmg image");
                    SwingUtilities.invokeLater(() -> this.frame.mp.defaultScene.notificationPanel.addNotification("macos-copy-icon", new Notification("macos-copy-icon", () -> Alert.showMessage("", Localizable.get("macos.please-install-notification")))));
                }
            }
        }
        this.executeWhenReady(() -> {
            if (this.getBootstrapVersion() != null) {
                Version version;
                try {
                    version = Version.valueOf((String)this.getBootstrapVersion());
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Couldn't parse bootstrap version: {}", (Object)this.getBootstrapVersion(), (Object)e);
                    Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't parse bootstrap version").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
                    return;
                }
                if (version.compareTo(Version.forIntegers((int)1, (int)5, (int)13)) == 0) {
                    LOGGER.info("Detected deprecated bootstrap version: {}", (Object)version);
                    LOGGER.info("Collecting environment information for an upcoming upgrade");
                    String gameDir = this.config.get("minecraft.gamedir");
                    Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.INFO).withMessage("Deprecated bootstrap: gameDir").withTag("gameDirAbsolute", String.valueOf(Paths.get(gameDir, new String[0]).isAbsolute())).withExtra("gameDir", (Object)StringUtils.replace((String)gameDir, (String)System.getProperty("user.name"), (String)"***")));
                }
            }
        });
        this.executeWhenReady(() -> {
            if (optionSet.has("username")) {
                User selectedUser;
                String forceSelectedUser = (String)optionSet.valueOf("username");
                Optional<String> forceSelectedUserType = Optional.ofNullable(optionSet.valueOf("usertype")).map(o -> (String)o);
                List selectedUsers = this.profileManager.getAccountManager().getUserSet().getSet().stream().filter(u -> u.getDisplayName().equals(forceSelectedUser)).collect(Collectors.toList());
                block0 : switch (selectedUsers.size()) {
                    case 0: {
                        if (!forceSelectedUserType.isPresent() || forceSelectedUserType.get().equals("plain")) {
                            LOGGER.info("Force selected user {} doesn't exist, but we'll create one for you", (Object)forceSelectedUser);
                            selectedUser = new PlainUser(forceSelectedUser, UUID.randomUUID());
                            this.profileManager.getAccountManager().getUserSet().add(selectedUser);
                            break;
                        }
                        LOGGER.warn("Force selected user {} (of type {}) doesn't exist", (Object)forceSelectedUser, (Object)forceSelectedUserType.get());
                        return;
                    }
                    case 1: {
                        LOGGER.info("Force selecting user {} for you", (Object)forceSelectedUser);
                        selectedUser = (User)selectedUsers.get(0);
                        break;
                    }
                    default: {
                        if (forceSelectedUserType.isPresent()) {
                            List filteredUsers = selectedUsers.stream().filter(u -> u.getType().equals(forceSelectedUserType.get())).collect(Collectors.toList());
                            switch (filteredUsers.size()) {
                                case 0: {
                                    LOGGER.warn("Found users with name {}, but none was of the type {}. A typo?", (Object)forceSelectedUser, (Object)forceSelectedUserType.get());
                                    return;
                                }
                                case 1: {
                                    LOGGER.info("Selecting user {} of type {} for you", (Object)forceSelectedUser, (Object)forceSelectedUserType.get());
                                    selectedUser = (User)filteredUsers.get(0);
                                    break block0;
                                }
                            }
                            LOGGER.warn("Something is very wrong with your account list. Take a look: {}", filteredUsers);
                            return;
                        }
                        LOGGER.warn("More than one user with name {} was found. Consider specifying a type with --usertype", (Object)forceSelectedUser);
                        selectedUser = (User)selectedUsers.get(0);
                    }
                }
                LOGGER.debug("Selecting user: {}", (Object)selectedUser);
                this.profileManager.getAccountManager().getUserSet().select(selectedUser);
            }
        });
        this.executeWhenReady(() -> {
            if (!this.config.getBoolean("llaunch-announced") && LLaunchFrame.isNotPostTlaunchEra()) {
                SwingUtilities.invokeLater(() -> this.frame.mp.defaultScene.notificationPanel.addNotification("llaunch-announced", new Notification("ll-square", () -> {
                    this.config.set("llaunch-announced", (Object)true);
                    this.frame.mp.defaultScene.notificationPanel.removeNotification("llaunch-announced");
                    LLaunchFrame.showInstance();
                })));
            }
        });
        this.executeWhenReady(() -> {
            boolean found;
            if (OS.LINUX.isCurrent()) {
                Path linuxFractureiser = FileUtils.getUserDirectory().toPath().resolve(".config").resolve(".data").resolve("lib.jar");
                found = Files.isRegularFile(linuxFractureiser, new LinkOption[0]);
                if (found) {
                    LOGGER.info("fractureiser detected in {}", (Object)linuxFractureiser);
                }
            } else if (OS.WINDOWS.isCurrent()) {
                boolean startup;
                String localAppData;
                String appData = System.getenv("APPDATA");
                if (appData == null) {
                    appData = System.getProperty("user.home") + "\\AppData";
                }
                if ((localAppData = System.getenv("LOCALAPPDATA")) == null) {
                    localAppData = System.getProperty("user.home") + "\\AppData\\Local";
                }
                Path edgePath = new File(localAppData + "\\Microsoft Edge").toPath();
                boolean edge = Stream.of(".ref", "client.jar", "lib.dll", "libWebGL64.jar").anyMatch(p -> Files.isRegularFile(edgePath.resolve((String)p), new LinkOption[0]));
                if (edge) {
                    LOGGER.warn("fractureiser trace detected in the \"Microsoft Edge\" dir");
                }
                if (startup = new File(appData + "\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\run.bat").isFile()) {
                    LOGGER.warn("Possible fractureiser trace detected in the Startup directory");
                }
                found = edge || startup;
            } else {
                return;
            }
            if (found) {
                Stats.fractureiserTraceDetected();
                Alert.showWarning("", Localizable.get("fractureiser.detected"));
            }
        });
        this.executeOnReadyJobs();
    }

    private ConnectivityManager initConnectivityManager() {
        ArrayList<ConnectivityManager.Entry> entries = new ArrayList<ConnectivityManager.Entry>();
        if (this.bootConfigEmpty) {
            entries.add(ConnectivityManager.forceFailed("boot").withPriority(Integer.MAX_VALUE));
        }
        entries.add(ConnectivityManager.checkByValidJson("official_repo", LAUNCHERMETA).withPriority(1000));
        this.authServerCheckEntry = AuthServerChecker.createEntry().withPriority(-500);
        entries.add(this.authServerCheckEntry);
        this.elyByCheckEntry = ConnectivityManager.checkByValidJson("account.ely.by", "https://account.ely.by/api/minecraft/session/profile/ffb3378cd561502fa78a08494be68811").withPriority(-500);
        entries.add(this.elyByCheckEntry);
        entries.add(ConnectivityManager.checkRepoByValidJson("repo", Repository.EXTRA_VERSION_REPO, "versions/versions.json"));
        entries.add(ConnectivityManager.checkByContent("launcher.mojang.com", "https://launcher.mojang.com", "").withPriority(-500));
        entries.add(ConnectivityManager.checkRepoByValidJson("official_repo_proxy", Repository.PROXIFIED_REPO, LAUNCHERMETA).withPriority(-1000));
        return new ConnectivityManager(this, entries);
    }

    private void bumpAuthServerCheckPriority() {
        this.authServerCheckEntry.withPriority(1000);
        this.authServerCheckEntry.getTask().thenRun(this.connectivityManager::showNotificationOnceIfNeeded);
    }

    private void migrateFromOldJreConfig() {
        String cmd = this.config.get("minecraft.cmd");
        if (cmd == null) {
            return;
        }
        LOGGER.info("Migrating from old JRE configuration");
        LOGGER.info("minecraft.cmd -> {} = {}", (Object)"minecraft.jre.custom.path", (Object)cmd);
        LOGGER.info("{} = {}", (Object)"minecraft.jre.type", (Object)"custom");
        this.config.set("minecraft.cmd", null);
        this.config.set("minecraft.jre.type", "custom");
        this.config.set("minecraft.jre.custom.path", cmd);
    }

    private void migrateLafConfigOrSetLaf() {
        boolean setSystemLaf;
        if (this.config.containsKey("gui.systemlookandfeel")) {
            setSystemLaf = this.config.getBoolean("gui.systemlookandfeel");
            LOGGER.info("FlatLaf is not enabled because \"gui.systemlookandfeel\" is set to \"" + setSystemLaf + "\"");
            if (FlatLaf.isSupported()) {
                this.config.set("gui.laf.v1.state", setSystemLaf ? FlatLafConfiguration.State.SYSTEM.toString() : FlatLafConfiguration.State.OFF.toString(), false);
                this.config.set("gui.systemlookandfeel", null);
                setSystemLaf = false;
            }
        } else {
            boolean bl = setSystemLaf = !this.hasCapability("set_laf");
        }
        if (setSystemLaf) {
            LOGGER.info("Setting system L&F");
            String systemLaf = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(systemLaf);
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't set system L&F: {}", (Object)systemLaf, (Object)e);
            }
        }
    }

    private void migrateMemoryValue() {
        if (this.config.get("minecraft.memory") == null) {
            return;
        }
        int oldValue = this.config.getInteger("minecraft.memory");
        if (oldValue == this.memoryAllocationService.getFallbackHint().getActual()) {
            LOGGER.info("Migrating to minecraft.xmx = \"auto\" because minecraft.memory = PREFERRED_MEMORY ({})", (Object)oldValue);
            this.config.set("minecraft.xmx", "auto", false);
        } else {
            LOGGER.info("Migrating to minecraft.xmx = minecraft.memory = {}", (Object)oldValue);
        }
        this.config.set("minecraft.memory", null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOnReadyJobs() {
        Object object = this.onReadySync;
        synchronized (object) {
            Runnable job;
            Objects.requireNonNull(this.onReadyJobs, "onReadyJobs");
            while ((job = this.onReadyJobs.poll()) != null) {
                try {
                    job.run();
                }
                catch (Exception e) {
                    LOGGER.error("OnReadyJob failed: {}", (Object)job, (Object)e);
                }
            }
            this.onReadyJobs = null;
        }
    }

    public BootConfiguration getBootConfig() {
        return this.bootConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isReady() {
        return this.ready;
    }

    public Configuration getSettings() {
        return this.config;
    }

    public LangConfiguration getLang() {
        return this.lang;
    }

    public ComponentManager getManager() {
        return this.componentManager;
    }

    public LibraryReplaceProcessor getLibraryManager() {
        return this.libraryReplaceManager;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public JavaManager getJavaManager() {
        return this.javaManager;
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public UIListeners getUIListeners() {
        return this.uiListeners;
    }

    public TLauncherFrame getFrame() {
        return this.frame;
    }

    public MinecraftLauncher getMinecraftLauncher() {
        return this.launcher;
    }

    public boolean isMinecraftLauncherWorking() {
        return this.launcher != null && this.launcher.isWorking();
    }

    public MinecraftLauncher newMinecraftLauncher(String versionName, Server server, int serverId, boolean forceUpdate) {
        if (this.isMinecraftLauncherWorking()) {
            throw new IllegalStateException("launcher is working");
        }
        this.launcher = new MinecraftLauncher(this, forceUpdate);
        for (MinecraftListener l : this.uiListeners.getMinecraftListeners()) {
            this.launcher.addListener(l);
        }
        this.launcher.setVersion(versionName);
        this.launcher.setServer(server, serverId);
        ArrayList<PromotedServer> promotedServerList = new ArrayList<PromotedServer>();
        if (this.bootConfig.getPromotedServers().containsKey(this.getSettings().getLocale().toString())) {
            promotedServerList.addAll((Collection)this.bootConfig.getPromotedServers().get(this.getSettings().getLocale().toString()));
        } else if (this.bootConfig.getPromotedServers().containsKey("global")) {
            promotedServerList.addAll((Collection)this.bootConfig.getPromotedServers().get("global"));
        }
        ArrayList<PromotedServer> outdatedServerList = new ArrayList<PromotedServer>();
        if (this.bootConfig.getOutdatedPromotedServers().containsKey(this.getSettings().getLocale().toString())) {
            outdatedServerList.addAll((Collection)this.bootConfig.getOutdatedPromotedServers().get(this.getSettings().getLocale().toString()));
        } else if (this.bootConfig.getOutdatedPromotedServers().containsKey("global")) {
            outdatedServerList.addAll((Collection<PromotedServer>)this.bootConfig.getOutdatedPromotedServers().get("global"));
        }
        this.launcher.setPromotedServers(promotedServerList, outdatedServerList);
        return this.launcher;
    }

    public static void kill() {
        if (TLauncher.getInstance() != null) {
            try {
                TLauncher.getInstance().getSettings().save();
            }
            catch (Exception e) {
                Alert.showError("Configuration error", "Could not save settings \u2013 this is not good. Please contact support if you want to solve this.", e);
            }
            LOGGER.info("Goodbye!");
            TLauncher.getInstance().frame.setVisible(false);
            try {
                Stats.reportSessionDuration(TLauncher.getInstance().sessionStartTime).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            TLauncher.getInstance().dispatcher.requestClose();
        } else {
            System.exit(0);
        }
    }

    private void initConfig() {
        SentryConfigurer.setUser(this.config.getClient());
        TLauncherFrame.setFontSize(this.config.getFontSize());
        if (!this.config.getBoolean("connection.ssl")) {
            LOGGER.warn("Disabling SSL certificate/hostname validation. IT IS NOT SECURE.");
            try {
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(null, new X509TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }}, null);
                HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            }
            catch (Exception e) {
                LOGGER.error("Could not init SSLContext", (Throwable)e);
            }
            HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
        }
        this.reloadLocale();
    }

    public void reloadLoggerUI() {
        boolean enableLogger;
        SwingLoggerAppender swingLoggerAppender = Log4j2ContextHelper.getSwingLoggerAppender();
        LoggerInterface li = swingLoggerAppender.getLoggerInterface();
        boolean bl = enableLogger = this.config.getLoggerType() == Configuration.LoggerType.GLOBAL;
        if (this.loggerUI == null) {
            if (!enableLogger) {
                return;
            }
            this.loggerUI = new SwingLogger(this.config);
            if (li instanceof LoggerBuffer) {
                this.loggerUI.drainFrom((LoggerBuffer)li);
            }
            swingLoggerAppender.setLoggerInterface(this.loggerUI);
            this.initLoggerUI();
            LOGGER.debug("Logger initialized");
        } else {
            if (enableLogger) {
                return;
            }
            swingLoggerAppender.setLoggerInterface(new LoggerBuffer());
            this.loggerUI.dispose();
            this.loggerUI = null;
            LOGGER.debug("Logger disposed");
        }
    }

    private void initLoggerUI() {
        this.loggerUI.setFolderAction(() -> {
            if (this.isMinecraftLauncherWorking()) {
                OS.openFolder(this.getMinecraftLauncher().getGameDir());
            } else {
                OS.openFolder(MinecraftUtil.getWorkingDirectory());
            }
        });
        this.loggerUI.setSaveAction(() -> OS.openFile(Log4j2ContextHelper.getCurrentLogFile().getFile()));
        this.updateLoggerUIActions();
        this.loggerUI.show();
    }

    public void updateLoggerUIActions() {
        if (this.loggerUI == null) {
            return;
        }
        if (this.isMinecraftLauncherWorking() && this.getMinecraftLauncher().isMinecraftRunning()) {
            this.loggerUI.setKillAction(() -> this.getMinecraftLauncher().killProcess());
        } else {
            this.loggerUI.setKillAction(null);
        }
    }

    private void handleNoticeHiding() {
        if (!this.isNoticeDisablingAllowed()) {
            this.config.set("notice.enabled", (Object)true);
        }
    }

    private void handleWorkdir() {
        if (this.config.isFirstRun()) {
            this.handleFirstRun();
        } else {
            this.config.set("minecraft.gamedir", MinecraftUtil.getWorkingDirectory(), false);
        }
    }

    private void handleUpdate() {
        String locale = this.getSettings().getLocale().toString();
        BootMessage message = this.dispatcher.getBootMessage(locale);
        if (message == null) {
            message = this.dispatcher.getBootMessage("en_US");
        }
        if (message != null) {
            new UpdateFrame(U.getMinorVersion(TLauncher.getVersion()), message.getBody()).showAndWait();
        }
    }

    private void handleFirstRun() {
        new FirstRunNotice().showAndWait();
        File currentDir = MinecraftUtil.getWorkingDirectory(false);
        LOGGER.info("Current dir: {}", (Object)currentDir);
        if (NewFolderFrame.shouldWeMoveFrom(currentDir) && (currentDir = NewFolderFrame.selectDestination()) != null) {
            new NewFolderFrame(this, currentDir).showAndWait();
        }
    }

    public boolean isNoticeDisablingAllowed() {
        return this.bootConfig.isAllowNoticeDisable(this.config.getClient());
    }

    public boolean isNoticeDisabled() {
        return this.isNoticeDisablingAllowed() && !this.config.getBoolean("notice.enabled");
    }

    private void initAndRefreshUI() {
        LoginForm lf = this.frame.mp.defaultScene.loginForm;
        if (lf.autologin.isEnabled()) {
            this.versionManager.startRefresh(true);
            lf.autologin.setActive(true);
        } else {
            this.versionManager.asyncRefresh();
        }
        this.profileManager.refresh();
        new ExtendedThread(() -> {
            Stats.submitNoticeStatus(this.config.getBoolean("notice.enabled"));
            while (!Thread.interrupted()) {
                try {
                    TimeUnit.MINUTES.sleep(30L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Stats.beacon();
            }
        }, "Beacon").start();
    }

    private void preloadUI() {
        this.frame.mp.defaultScene.settingsForm.load();
    }

    public void reloadLocale() {
        Locale locale = this.config.getLocale();
        LOGGER.info("Selected locale: {}", (Object)locale);
        this.lang.setLocale(locale);
        SwingUtil.wait(() -> {
            Localizable.setLang(this.lang);
            Alert.prepareLocal();
            if (this.loggerUI != null) {
                this.loggerUI.updateLocale();
            }
            if (this.uiListeners != null) {
                this.uiListeners.updateLocale();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWhenReady(Runnable r) {
        Object object = this.onReadySync;
        synchronized (object) {
            if (this.onReadyJobs == null) {
                r.run();
            } else {
                this.onReadyJobs.offer(r);
            }
        }
    }

    private void checkReportsCapabilities() {
        boolean reportsCapabilities = true;
        try {
            this.bridge.getCapabilities();
        }
        catch (NoSuchMethodError e) {
            LOGGER.info("Bootstrap doesn't report capabilities");
            reportsCapabilities = false;
        }
        this.reportsCapabilities = reportsCapabilities;
    }

    public <V> Optional<V> getCapability(String key, Class<V> capabilityClass) {
        if (!this.reportsCapabilities) {
            return Optional.empty();
        }
        Object o = this.bridge.getCapabilities().get(key);
        if (o == null) {
            return Optional.empty();
        }
        if (!capabilityClass.isInstance(o)) {
            LOGGER.warn("Capability type mismatch! Key: {}, expected: {}, got: {}", (Object)key, capabilityClass, o.getClass());
            return Optional.empty();
        }
        return Optional.of(capabilityClass.cast(o));
    }

    public boolean hasCapability(String key) {
        if (!this.reportsCapabilities) {
            return false;
        }
        return this.bridge.getCapabilities().containsKey(key);
    }

    public static TLauncher getInstance() {
        return instance;
    }

    public static Version getVersion() {
        return SEMVER;
    }

    public String getBootstrapVersion() {
        return this.bridge.getBootstrapVersion();
    }

    public MemoryAllocationService getMemoryAllocationService() {
        return this.memoryAllocationService;
    }

    public static String getBrand() {
        return Static.getBrand();
    }

    public static String getShortBrand() {
        return Static.getShortBrand();
    }

    public static String getFolder() {
        return Static.getFolder();
    }

    public static String getSettingsFile() {
        return Static.getSettings();
    }

    public static List<String> getOfficialRepo() {
        return Static.getOfficialRepo();
    }

    public static List<String> getExtraRepo() {
        return Static.getExtraRepo();
    }

    public static List<String> getLibraryRepo() {
        return Static.getLibraryRepo();
    }

    public static List<String> getAssetsRepo() {
        return Static.getAssetsRepo();
    }

    public static List<String> getServerList() {
        return Static.getServerList();
    }

    public static String getSupportEmail() {
        return "support@tln4.ru";
    }

    public GPUManager getGpuManager() {
        return this.gpuManager;
    }

    public PromotedStoreManager getPromotedStoreManager() {
        return this.promotedStoreManager;
    }

    public Optional<String> getPackageMode() {
        return this.getCapability("package_mode", String.class);
    }

    public static void launch(BootBridge bridge) throws InterruptedException {
        TLauncher.checkNotRunning();
        TLauncher.setupErrorHandler();
        LOGGER.info("Starting Legacy Launcher {} {}", (Object)TLauncher.getBrand(), (Object)U.getFormattedVersion(TLauncher.getVersion()));
        if (bridge.getBootstrapVersion() != null) {
            LOGGER.info("... using Bootstrap {}", (Object)bridge.getBootstrapVersion());
        }
        LOGGER.info("Machine info: {}", (Object)OS.getSummary());
        LOGGER.info("Java version: {}", (Object)OS.JAVA_VERSION);
        LOGGER.info("Startup time: {}", (Object)Instant.now());
        LOGGER.info("Directory: {}", (Object)new File(""));
        LOGGER.info("Executable location: {}", (Object)FileUtil.getRunningJar());
        LOGGER.info("---");
        BootEventDispatcher dispatcher = bridge.setupDispatcher();
        dispatcher.onBootStarted();
        try {
            new TLauncher(bridge, dispatcher);
        }
        catch (Throwable t) {
            LOGGER.fatal("Error launching Legacy Launcher", t);
            dispatcher.onBootErrored(t);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        TLauncher.launch(BootBridge.create((String[])args));
    }

    private static void checkNotRunning() {
        if (instance != null) {
            throw new IllegalStateException("already running");
        }
    }

    private static void setupErrorHandler() {
        ExceptionHandler handler = ExceptionHandler.getInstance();
        Thread.setDefaultUncaughtExceptionHandler(handler);
        Thread.currentThread().setUncaughtExceptionHandler(handler);
    }

    static {
        SEMVER = Objects.requireNonNull(Version.valueOf((String)"1.159.2+legacy"), "semver");
        System.setProperty("java.net.useSystemProxies", "true");
        SentryConfigurer.configure(TLauncher.getVersion(), TLauncher.getShortBrand());
    }
}

