/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.tl.modloader.extractor;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.http.client.fluent.Request;
import pw.modder.http.HttpClientUtils;
import pw.modder.tl.modloader.extractor.ForgeExtractor;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;

public class ForgeProcessor {
    private final ForgeExtractor.InstallProfile profile;
    private final Map<String, String> vars = new HashMap<String, String>();
    private final Path temp;
    private final Path librariesDir;

    public ForgeProcessor(ForgeExtractor.InstallProfile profile, File librariesDir, File versionsDir) throws IOException, IllegalArgumentException {
        if (profile.getJson() != null && profile.getJsonData() == null) {
            throw new IllegalArgumentException("Forge (new) version data is not loaded!");
        }
        this.profile = profile;
        this.temp = Files.createTempDirectory("tl-forge", new FileAttribute[0]);
        String minecraft_version = profile.getMinecraft();
        this.librariesDir = librariesDir.toPath();
        profile.getData().forEach((key, value) -> {
            String val = value.getClient();
            int len = val.length();
            if (val.charAt(0) == '[' && val.charAt(len - 1) == ']') {
                this.vars.put((String)key, this.librariesDir.resolve(ForgeProcessor.getArtifact(val.substring(1, len - 1))).toAbsolutePath().toString());
            } else if (val.charAt(0) == '\'' && val.charAt(len - 1) == '\'') {
                this.vars.put((String)key, val.substring(1, len - 1));
            } else {
                this.vars.put((String)key, this.temp.resolve(val).toAbsolutePath().toString());
            }
        });
        this.vars.put("SIDE", "client");
        this.vars.put("MINECRAFT_JAR", new File(versionsDir, minecraft_version + "/" + minecraft_version + ".jar").getAbsolutePath());
    }

    public void downloadLibraries() throws IOException {
        if (this.profile.getLibraries() == null) {
            return;
        }
        for (ForgeExtractor.ProcessorLibrary library : this.profile.getLibraries()) {
            File target = this.librariesDir.resolve(library.getPath()).toFile();
            HttpClientUtils.execute(Request.Get((String)library.getUrl())).saveContent(target);
            if (FileUtil.getSHA(target).equals(library.getSha1())) continue;
            throw new IOException("Error downloading " + library.getName() + ", SHA1 mismatch!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runProcessors() throws IOException, InterruptedException {
        if (this.profile.getProcessors() == null) {
            return;
        }
        for (ForgeExtractor.ForgeProcessor processor : this.profile.getProcessors()) {
            String mainClass;
            Path jar = this.librariesDir.resolve(ForgeProcessor.getArtifact(processor.getJar()));
            String classpath = processor.getClasspath().stream().map(lib -> this.librariesDir.resolve(ForgeProcessor.getArtifact(lib)).toAbsolutePath().toString()).collect(Collectors.joining(File.pathSeparator));
            classpath = classpath + File.pathSeparator + jar.toAbsolutePath();
            try (JarFile jarFile = new JarFile(jar.toFile());){
                mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            List<String> commands = Arrays.asList("-cp", classpath, mainClass);
            List processed_args = processor.getArgs().stream().map(this::processVar).collect(Collectors.toList());
            commands.addAll(processed_args);
            JavaProcessLauncher l = new JavaProcessLauncher(Charsets.UTF_8, OS.getJavaPath(), commands.toArray(new String[0]));
            JavaProcess p = l.start();
            p.getRawProcess().waitFor();
            if (processor.getOutput() == null) continue;
            for (Map.Entry<String, String> entry : processor.getOutput().entrySet()) {
                File file = new File(this.vars.get(this.processVar(entry.getKey())));
                String sha1 = this.vars.get(this.processVar(entry.getValue()));
                if (sha1.equals(FileUtil.getSHA(file))) continue;
                throw new IllegalArgumentException("Processor output SHA is not expected");
            }
        }
    }

    public CompleteVersion getCompleteVersion() {
        if (this.profile.getJson() == null) {
            return this.profile.getVersionInfo().getCompleteVersion();
        }
        return this.profile.getJsonData();
    }

    private String processVar(String val) {
        int len = val.length();
        if (val.charAt(0) == '[' && val.charAt(len - 1) == ']') {
            return this.librariesDir.resolve(ForgeProcessor.getArtifact(val.substring(1, len - 1))).toAbsolutePath().toString();
        }
        if (val.charAt(0) == '{' && val.charAt(len - 1) == '}') {
            return this.vars.get(val.substring(1, len - 1));
        }
        return val;
    }

    private static String getArtifact(String name) {
        String extension;
        if (name == null) {
            throw new NullPointerException("Artifact name is null!");
        }
        String[] name_parts = name.split("@", 2);
        String[] path_parts = name_parts[0].split(":", 4);
        String string = extension = name_parts.length == 2 ? name_parts[1] : "jar";
        if (path_parts.length == 4) {
            return String.format(Locale.ROOT, "%1$s/%2$s/%3$s/%2$s-%3$s-%4$s.%5$s", path_parts[0].replace('.', '/'), path_parts[1], path_parts[2], path_parts[3], extension);
        }
        if (path_parts.length == 3) {
            return String.format(Locale.ROOT, "%1$s/%2$s/%3$s/%2$s-%3$s.%4$s", path_parts[0].replace('.', '/'), path_parts[1], path_parts[2], extension);
        }
        throw new IllegalArgumentException("Provided string is not a Maven Artifact locator!");
    }
}

