/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.tl.modloader.extractor;

import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import org.apache.commons.io.IOUtils;
import ru.turikhay.util.U;

public class ForgeExtractor {
    private ForgeExtractor() {
    }

    public static pw.modder.tl.modloader.extractor.ForgeProcessor ExtractProfile(File file, File librariesDir, File versionsDir) throws IOException {
        ZipEntry versionEntry;
        ZipFile zipFile = new ZipFile(file);
        ZipEntry profileEntry = zipFile.getEntry("install_profile.json");
        if (profileEntry == null) {
            throw new IOException(zipFile.getName() + ": cannot load install_profile.json");
        }
        InstallProfile profile = (InstallProfile)U.getGson().fromJson(IOUtils.toString((InputStream)zipFile.getInputStream(profileEntry), (Charset)StandardCharsets.UTF_8), InstallProfile.class);
        if (profile.getVersionInfo() != null) {
            return new pw.modder.tl.modloader.extractor.ForgeProcessor(profile, librariesDir, versionsDir);
        }
        if (profile.getJson() != null && zipFile.getEntry(profile.getJson()) != null && (versionEntry = zipFile.getEntry(profile.getJson())) != null) {
            profile.setJsonData((CompleteVersion)U.getGson().fromJson(IOUtils.toString((InputStream)zipFile.getInputStream(profileEntry), (Charset)StandardCharsets.UTF_8), CompleteVersion.class));
            return new pw.modder.tl.modloader.extractor.ForgeProcessor(profile, librariesDir, versionsDir);
        }
        throw new IOException("Cannot parse " + file.getName() + ", unknown format");
    }

    public static class InstallProfile {
        private Install install;
        private VersionInfo versionInfo;
        private String path;
        private String json;
        private String minecraft;
        private Map<String, ForgeData> data;
        private List<ForgeProcessor> processors;
        private List<ProcessorLibrary> libraries;
        @Expose(serialize=false, deserialize=false)
        private CompleteVersion jsonData;

        public Install getInstall() {
            return this.install;
        }

        public String getMinecraft() {
            if (this.install == null) {
                return this.minecraft;
            }
            return this.install.minecraft;
        }

        public VersionInfo getVersionInfo() {
            return this.versionInfo;
        }

        public String getPath() {
            return this.path;
        }

        public String getJson() {
            return this.json;
        }

        void setJsonData(CompleteVersion jsonData) {
            this.jsonData = jsonData;
        }

        public CompleteVersion getJsonData() {
            return this.jsonData;
        }

        public List<ForgeProcessor> getProcessors() {
            return this.processors;
        }

        public List<ProcessorLibrary> getLibraries() {
            return this.libraries;
        }

        public Map<String, ForgeData> getData() {
            return this.data;
        }
    }

    public static class VersionInfo {
        private String id;
        private String minecraftArguments;
        private String mainClass;
        private String assets;
        private String jar;
        private Date time;
        private Date releaseDate;
        private Integer minimumLauncherVersion;
        private List<VersionInfoLibrary> libraries;

        public CompleteVersion getCompleteVersion() {
            return new CompleteVersion(this.id, this.minecraftArguments, this.mainClass, this.assets, this.jar, this.time, this.releaseDate, this.minimumLauncherVersion, this.libraries.stream().filter(VersionInfoLibrary::isClient).map(VersionInfoLibrary::getLibrary).collect(Collectors.toList()));
        }
    }

    public static class ForgeProcessor {
        private String jar;
        private List<String> classpath;
        private List<String> args;
        private Map<String, String> output;

        public String getJar() {
            return this.jar;
        }

        public List<String> getClasspath() {
            return this.classpath;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public Map<String, String> getOutput() {
            return this.output;
        }
    }

    public static class ForgeData {
        private String client;
        private String server;

        public String getClient() {
            return this.client;
        }

        public String getServer() {
            return this.server;
        }
    }

    private static class VersionInfoLibrary {
        private String name;
        private String url;
        private Boolean clientreq;
        private Boolean serverreq;
        private List<String> checksums;

        private VersionInfoLibrary() {
        }

        public Library getLibrary() {
            return new Library(this.name, this.url, this.checksums.stream().findFirst().orElse(null));
        }

        public boolean isClient() {
            return this.clientreq != null && this.clientreq != false;
        }
    }

    static class Install {
        private String profileName;
        private String version;
        private String minecraft;

        Install() {
        }

        public String getProfileName() {
            return this.profileName;
        }

        public String getVersion() {
            return this.version;
        }

        public String getMinecraft() {
            return this.minecraft;
        }
    }

    private static class Artifact {
        private String path;
        private String url;
        private String sha1;
        private long size;

        private Artifact() {
        }
    }

    private static class Downloads {
        private Artifact artifact;

        private Downloads() {
        }
    }

    public static class ProcessorLibrary {
        private String name;
        private Downloads downloads;

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.downloads.artifact.path;
        }

        public String getUrl() {
            return this.downloads.artifact.url;
        }

        public long getSize() {
            return this.downloads.artifact.size;
        }

        public String getSha1() {
            return this.downloads.artifact.sha1;
        }
    }
}

