/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.tl.modloader;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.launcher.versions.Library;
import org.apache.http.client.fluent.Request;
import pw.modder.http.HttpClientUtils;
import ru.turikhay.util.U;

public interface ModloaderList {
    public List<String> list(String var1);

    public Optional<String> getStable(String var1);

    public Optional<String> getLatest(String var1);

    public void fetch() throws IOException;

    public static class Fabric
    implements ModloaderList {
        private static final String FABRIC_LIST_URL = "https://meta.fabricmc.net/v2/versions/loader";
        private static final Type METADATA_TYPE = new TypeToken<List<FabricLoaderMeta>>(){}.getType();
        private List<FabricLoaderMeta> versions = Collections.emptyList();

        @Override
        public List<String> list(String minecraftVersion) {
            return this.versions.stream().map(FabricLoaderMeta::getVersion).collect(Collectors.toList());
        }

        @Override
        public Optional<String> getStable(String minecraftVersion) {
            return this.versions.stream().filter(FabricLoaderMeta::isStable).findFirst().map(FabricLoaderMeta::getVersion);
        }

        @Override
        public Optional<String> getLatest(String minecraftVersion) {
            return this.versions.stream().max(Comparator.comparing(FabricLoaderMeta::getBuild)).map(FabricLoaderMeta::getVersion);
        }

        @Override
        public void fetch() throws IOException {
            this.versions = (List)U.getGson().fromJson(HttpClientUtils.execute(Request.Get((String)FABRIC_LIST_URL)).returnContent().asString(StandardCharsets.UTF_8), METADATA_TYPE);
        }

        private static class FabricLoaderMeta {
            private String separator;
            private String maven;
            private String version;
            private int build;
            private boolean stable;

            private FabricLoaderMeta() {
            }

            public String getSeparator() {
                return this.separator;
            }

            public String getMaven() {
                return this.maven;
            }

            public String getVersion() {
                return this.version;
            }

            public int getBuild() {
                return this.build;
            }

            public boolean isStable() {
                return this.stable;
            }
        }
    }

    public static class LiteLoader
    implements ModloaderList {
        private static final String VERSIONS_LIST_URL = "http://dl.liteloader.com/versions/versions.json";
        private Versions versions;

        @Override
        public List<String> list(String minecraftVersion) {
            Optional<LiteLoaderVersion> list = this.versions.getVersion(minecraftVersion);
            return list.map(liteLoaderVersion -> liteLoaderVersion.getAll().stream().map(LiteLoaderVersionEntry::getVersion).collect(Collectors.toList())).orElse(Collections.emptyList());
        }

        @Override
        public Optional<String> getStable(String minecraftVersion) {
            return this.versions.getVersion(minecraftVersion).map(LiteLoaderVersion::getReleases).map(LiteLoaderVersionMeta::getLatest).flatMap(it -> it).map(LiteLoaderVersionEntry::getVersion);
        }

        @Override
        public Optional<String> getLatest(String minecraftVersion) {
            return this.versions.getVersion(minecraftVersion).map(LiteLoaderVersion::getSnapshots).map(LiteLoaderVersionMeta::getLatest).flatMap(it -> it).map(LiteLoaderVersionEntry::getVersion);
        }

        @Override
        public void fetch() throws IOException {
            U.getGson().fromJson(HttpClientUtils.execute(Request.Get((String)VERSIONS_LIST_URL)).returnContent().asString(), Versions.class);
        }

        static class Versions {
            private Map<String, LiteLoaderVersion> versions;

            Versions() {
            }

            public Optional<LiteLoaderVersion> getVersion(String minecraft) {
                if (this.versions.containsKey(minecraft)) {
                    return Optional.of(this.versions.get(minecraft));
                }
                return Optional.empty();
            }
        }

        private static class LiteLoaderVersion {
            private LiteLoaderVersionMeta artifacts;
            private LiteLoaderVersionMeta snapshots;
            private LiteLoaderVersionRepo repo;

            private LiteLoaderVersion() {
            }

            public LiteLoaderVersionMeta getSnapshots() {
                return this.snapshots;
            }

            public LiteLoaderVersionMeta getReleases() {
                return this.artifacts;
            }

            public List<LiteLoaderVersionEntry> getAll() {
                ArrayList<LiteLoaderVersionEntry> vers = new ArrayList<LiteLoaderVersionEntry>(this.artifacts.versions.size() + this.snapshots.versions.size());
                vers.addAll(this.artifacts.versions.values());
                vers.addAll(this.snapshots.versions.values());
                return vers;
            }
        }

        static enum LiteLoaderStream {
            SNAPSHOT,
            RELEASE;

        }

        private static class LiteLoaderVersionEntry {
            private String tweakClass;
            private String file;
            private String version;
            private String md5;
            private List<Library> libraries;
            private LiteLoaderStream stream;

            private LiteLoaderVersionEntry() {
            }

            public boolean isStable() {
                return this.stream == LiteLoaderStream.RELEASE;
            }

            public String getTweakClass() {
                return this.tweakClass;
            }

            public String getFile() {
                return this.file;
            }

            public String getVersion() {
                return this.version;
            }

            public String getMd5() {
                return this.md5;
            }

            public List<Library> getLibraries() {
                return this.libraries;
            }
        }

        private static class LiteLoaderVersionMeta {
            @SerializedName(value="com.mumfrey:liteloader")
            private Map<String, LiteLoaderVersionEntry> versions;

            private LiteLoaderVersionMeta() {
            }

            public Optional<LiteLoaderVersionEntry> getEntry(String md5) {
                if (this.versions.containsKey(md5)) {
                    return Optional.of(this.versions.get(md5));
                }
                return Optional.empty();
            }

            public Optional<LiteLoaderVersionEntry> getLatest() {
                return this.getEntry("latest");
            }
        }

        private static class LiteLoaderVersionRepo {
            private String url;
            private LiteLoaderStream stream;

            private LiteLoaderVersionRepo() {
            }
        }
    }

    public static class Forge
    implements ModloaderList {
        private static final String FORGE_MAVEN_METADATA_URL = "https://files.minecraftforge.net/maven/net/minecraftforge/forge/maven-metadata.json";
        private static final String FORGE_PROMOTIONS_URL = "https://files.minecraftforge.net/maven/net/minecraftforge/forge/promotions_slim.json";
        private static final Type METADATA_TYPE = new TypeToken<Map<String, List<String>>>(){}.getType();
        private Map<String, List<String>> versions = Collections.emptyMap();
        private Promotions promotions = new Promotions();

        @Override
        public List<String> list(String minecraftVersion) {
            return this.versions.getOrDefault(minecraftVersion, Collections.emptyList());
        }

        @Override
        public Optional<String> getStable(String minecraftVersion) {
            return this.promotions.getRecommended(minecraftVersion);
        }

        @Override
        public Optional<String> getLatest(String minecraftVersion) {
            return this.promotions.getLatest(minecraftVersion);
        }

        @Override
        public void fetch() throws IOException {
            this.versions = (Map)U.getGson().fromJson(HttpClientUtils.execute(Request.Get((String)FORGE_MAVEN_METADATA_URL)).returnContent().asString(StandardCharsets.UTF_8), METADATA_TYPE);
            this.promotions = (Promotions)U.getGson().fromJson(HttpClientUtils.execute(Request.Get((String)FORGE_PROMOTIONS_URL)).returnContent().asString(StandardCharsets.UTF_8), Promotions.class);
        }

        private static class Promotions {
            private final Map<String, String> promos = Collections.emptyMap();

            private Promotions() {
            }

            public Optional<String> getRecommended(String minecraft) {
                if (this.promos.containsKey(minecraft + "-recommended")) {
                    return Optional.of(this.promos.get(minecraft + "-recommended"));
                }
                return Optional.empty();
            }

            public Optional<String> getLatest(String minecraft) {
                if (this.promos.containsKey(minecraft + "-latest")) {
                    return Optional.of(this.promos.get(minecraft + "-recommended"));
                }
                return Optional.empty();
            }
        }
    }
}

