/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.tl.modloader;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.http.client.fluent.Request;
import pw.modder.http.HttpClientUtils;
import pw.modder.tl.modloader.ModloaderFamily;
import pw.modder.tl.modloader.extractor.ForgeExtractor;
import pw.modder.tl.modloader.extractor.ForgeProcessor;
import ru.turikhay.util.U;

public interface Modloader {
    public CompleteVersion install(String var1, String var2, File var3, File var4) throws IOException;

    public ModloaderFamily getFamily();

    public String getMinecraftVersion();

    public String getModloaderVersion();

    public static class Fabric
    implements Modloader {
        private final String minecraft;
        private final String version;
        private static final String API_META_URL = "https://meta.fabricmc.net/v2/versions/loader/%s/%s/profile/json";

        public Fabric(String minecraft, String version) {
            this.minecraft = minecraft;
            this.version = version;
        }

        @Override
        public ModloaderFamily getFamily() {
            return ModloaderFamily.FABRIC;
        }

        @Override
        public String getMinecraftVersion() {
            return this.minecraft;
        }

        @Override
        public String getModloaderVersion() {
            return this.version;
        }

        @Override
        public CompleteVersion install(String versionName, String versionFamily, File versionsDir, File librariesDir) throws IOException {
            CompleteVersion completeVersion = (CompleteVersion)U.getGson().fromJson(HttpClientUtils.execute(Request.Get((String)String.format(Locale.ROOT, API_META_URL, this.minecraft, this.version))).returnContent().asString(), CompleteVersion.class);
            completeVersion.setID(versionName);
            completeVersion.setFamily(versionFamily);
            return completeVersion;
        }
    }

    public static class Forge
    implements Modloader {
        private static final String FORGE_INSTALLER_URL = "https://files.minecraftforge.net/maven/net/minecraftforge/forge/%1$s-%2$s/forge-%1$s-%2$s-installer.jar";
        private final String minecraft;
        private final String version;
        private final String url;

        public Forge(String minecraft, String version) {
            this.minecraft = minecraft;
            this.version = version;
            this.url = String.format(Locale.ROOT, FORGE_INSTALLER_URL, minecraft, version);
        }

        public Forge(String minecraft, String version, String url) {
            this.minecraft = minecraft;
            this.version = version;
            this.url = url;
        }

        @Override
        public CompleteVersion install(String versionName, String versionFamily, File versionsDir, File librariesDir) throws IOException {
            File tempFile = File.createTempFile("forge", ".jar");
            HttpClientUtils.execute(Request.Get((String)this.url)).saveContent(tempFile);
            ForgeProcessor fpr = ForgeExtractor.ExtractProfile(tempFile, librariesDir, versionsDir);
            fpr.downloadLibraries();
            try {
                fpr.runProcessors();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            CompleteVersion ver = fpr.getCompleteVersion();
            ver.setID(versionName);
            ver.setFamily(versionFamily);
            return ver;
        }

        @Override
        public ModloaderFamily getFamily() {
            return ModloaderFamily.FORGE;
        }

        @Override
        public String getMinecraftVersion() {
            return this.minecraft;
        }

        @Override
        public String getModloaderVersion() {
            return this.version;
        }
    }
}

