/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.tl.curse;

import java.io.IOException;
import java.util.Set;
import pw.modder.tl.curse.AddonFile;
import pw.modder.tl.curse.CurseClient;

public class ModpackManifest {
    private MinecraftData minecraft;
    private String manifestType;
    private short manifestVersion;
    private String name;
    private String version;
    private String author;
    private Set<ModFile> files;
    private String overrides;

    public MinecraftData getMinecraft() {
        return this.minecraft;
    }

    public String getManifestType() {
        return this.manifestType;
    }

    public short getManifestVersion() {
        return this.manifestVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public Set<ModFile> getFiles() {
        return this.files;
    }

    public String getOverrides() {
        return this.overrides;
    }

    public static class MinecraftData {
        private String version;
        private Set<ModloaderData> modloaders;

        public String getVersion() {
            return this.version;
        }

        public Set<ModloaderData> getModloaders() {
            return this.modloaders;
        }
    }

    public static class ModFile {
        private int projectID;
        private int fileID;
        private boolean required;
        private Long checksum = null;
        private String downloadUrl = null;

        public void fetchFile() throws IOException {
            AddonFile file = this.getAddonFile();
            this.checksum = file.getPackageFingerprint();
            this.downloadUrl = file.getDownloadUrl();
        }

        public Long getChecksum() {
            return this.checksum;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public int getProjectID() {
            return this.projectID;
        }

        public int getFileID() {
            return this.fileID;
        }

        public boolean isRequired() {
            return this.required;
        }

        public AddonFile getAddonFile() throws IOException {
            return CurseClient.getAddonFile(this.projectID, this.fileID);
        }

        public String getDownloadLink() throws IOException {
            return CurseClient.getAddonFileDownloadURL(this.projectID, this.fileID);
        }
    }

    public static class ModloaderData {
        private String id;
        private boolean primary;

        public String getId() {
            return this.id;
        }

        public boolean isPrimary() {
            return this.primary;
        }
    }
}

