/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.tl.curse;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import pw.modder.tl.curse.AddonFile;
import pw.modder.tl.curse.AddonFileReleaseType;
import pw.modder.tl.curse.CurseClient;

public class AddonInfo {
    private int id;
    private String name;
    private Set<Author> authors;
    private String websiteUrl;
    private int gameId;
    private String summary;
    private int defaultFileId;
    private long downloadCount;
    private Set<AddonFile> latestFiles;
    private Status status;
    private String slug;
    private Set<LatestFile> gameVersionLatestFiles;
    private Instant dateModified;
    private Instant dateCreated;
    private Instant dateReleased;
    private boolean isAvailable;
    private boolean isExperiemental;

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<Author> getAuthors() {
        return this.authors;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public int getGameId() {
        return this.gameId;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getDefaultFileId() {
        return this.defaultFileId;
    }

    public long getDownloadCount() {
        return this.downloadCount;
    }

    public Set<AddonFile> getLatestFiles() {
        return this.latestFiles;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getSlug() {
        return this.slug;
    }

    public Set<LatestFile> getGameVersionLatestFiles() {
        return this.gameVersionLatestFiles;
    }

    public Instant getDateModified() {
        return this.dateModified;
    }

    public Instant getDateCreated() {
        return this.dateCreated;
    }

    public Instant getDateReleased() {
        return this.dateReleased;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isExperiemental() {
        return this.isExperiemental;
    }

    public AddonFile getFile(LatestFile file) throws IOException {
        return CurseClient.getAddonFile(this.id, file.getProjectFileId());
    }

    public AddonFile getFile(int fileId) throws IOException {
        return CurseClient.getAddonFile(this.id, fileId);
    }

    public List<AddonFile> getFiles() throws IOException {
        return CurseClient.getAddonFiles(this.id);
    }

    public String getFileDownloadLink(int fileId) throws IOException {
        return CurseClient.getAddonFileDownloadURL(this.id, fileId);
    }

    public static enum Status {
        NEW,
        CHANGES_REQUIRED,
        UNDER_SOFT_REVIEW,
        APPROVED,
        REJECTED,
        CHANGES_MADE,
        INACTIVE,
        ABANDONED,
        DELETED,
        UNDER_REVIEW;

    }

    public static class LatestFile {
        private String gameVersion;
        private int projectFileId;
        private String projectFileName;
        private AddonFileReleaseType fileType;

        public String getGameVersion() {
            return this.gameVersion;
        }

        public int getProjectFileId() {
            return this.projectFileId;
        }

        public String getProjectFileName() {
            return this.projectFileName;
        }

        public AddonFileReleaseType getFileType() {
            return this.fileType;
        }
    }

    public static class Author {
        private String name;
        private String url;
        private int projectId;
        private int id;
        private int userId;

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int getProjectId() {
            return this.projectId;
        }

        public int getId() {
            return this.id;
        }

        public int getUserId() {
            return this.userId;
        }
    }
}

