/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.tl.curse;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Set;
import pw.modder.hashing.MurmurHash2;
import pw.modder.tl.curse.AddonFileReleaseType;
import pw.modder.tl.curse.CurseClient;

public class AddonFile {
    private int id;
    private String displayName;
    private String fileName;
    private Instant fileDate;
    private long fileLength;
    private AddonFileReleaseType releaseType;
    private Status fileStatus;
    private String downloadUrl;
    private boolean isAlternate;
    private short alternateFileId;
    private Set<Dependency> dependencies;
    private boolean isAvailable;
    private long packageFingerprint;
    private Set<String> gameVersion;

    public int getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Instant getFileDate() {
        return this.fileDate;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public Status getFileStatus() {
        return this.fileStatus;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean isAlternate() {
        return this.isAlternate;
    }

    public short getAlternateFileId() {
        return this.alternateFileId;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public long getPackageFingerprint() {
        return this.packageFingerprint;
    }

    public Set<String> getGameVersion() {
        return this.gameVersion;
    }

    public boolean hashMatches(long hash) {
        return this.packageFingerprint == hash;
    }

    public boolean hashMatches(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        return MurmurHash2.hash32normalized(file) == this.packageFingerprint;
    }

    public boolean gameVersionMatches(String version) {
        if (this.gameVersion.isEmpty()) {
            return false;
        }
        return this.gameVersion.stream().anyMatch(it -> it.equals(version));
    }

    public static enum Status {
        PROCESSING,
        CHANGES_REQUIRED,
        UNDER_REVIEW,
        APPROVED,
        REJECTED,
        MALWARE_DETECTED,
        DELETED,
        ARCHIVED,
        TESTING,
        RELEASED,
        READY_FOR_REVIEW,
        DEPRECATED,
        BAKING,
        AWAITING_FOR_PUBLISHING,
        FAILED_PUBLISHING;

    }

    public static enum DependencyType {
        EMBEDDED_LIBRARY,
        OPTIONAL_DEPENDENCY,
        REQUIRED_DEPENDENCY,
        TOOL,
        INCOMPATIBLE,
        INCLUDE;

    }

    public static class Dependency {
        private long id;
        private int addonId;
        private DependencyType type;
        private int fileId;

        public long getId() {
            return this.id;
        }

        public int getAddonId() {
            return this.addonId;
        }

        public DependencyType getType() {
            return this.type;
        }

        public int getFileId() {
            return this.fileId;
        }

        public AddonFile getFile() throws IOException {
            return CurseClient.getAddonFile(this.addonId, this.fileId);
        }

        public String getDownloadLink() throws IOException {
            return CurseClient.getAddonFileDownloadURL(this.addonId, this.fileId);
        }
    }
}

