/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class InstantSerializer
implements JsonSerializer<Instant>,
JsonDeserializer<Instant> {
    public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(json.getAsString()));
    }

    public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(DateTimeFormatter.ISO_INSTANT.format(src));
    }
}

