/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.serialization;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class EnumSerializer<T extends Enum<T>>
extends TypeAdapter<T> {
    private final T[] enums;

    public EnumSerializer(Class<T> enumClass) {
        this.enums = (Enum[])enumClass.getEnumConstants();
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value((long)(((Enum)value).ordinal() + 1));
    }

    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        int ordinal = in.nextInt() - 1;
        if (ordinal < 0 || ordinal >= this.enums.length) {
            throw new OrdinalOutOfBoundsException(ordinal);
        }
        return this.enums[ordinal];
    }

    static class OrdinalOutOfBoundsException
    extends RuntimeException {
        public OrdinalOutOfBoundsException(int ordinal) {
            super("Enum ordinal out of bounds: " + ordinal);
        }
    }
}

