/*
 * Decompiled with CFR 0.152.
 */
package pw.modder.hashing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;

public class MurmurHash2 {
    private static final long M32 = 1540483477L;
    private static final int R32 = 24;
    private static final int SEED = 1;

    private MurmurHash2() {
    }

    public static long hash32(File inputFile) throws IOException {
        return MurmurHash2.hash32(inputFile, false);
    }

    public static long hash32normalized(File inputFile) throws IOException {
        return MurmurHash2.hash32(inputFile, true);
    }

    private static long hash32(File file, boolean normalized) throws IOException {
        int lengthMatching;
        long length = Files.size(file.toPath());
        if (length < 0L) {
            throw new IOException("invalid file size: " + length);
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            lengthMatching = MurmurHash2.countMatchingBytes(is, normalized);
        }
        is = new BufferedInputStream(new FileInputStream(file));
        try {
            long l = MurmurHash2.hash32(is, lengthMatching, normalized);
            return l;
        }
        finally {
            is.close();
        }
    }

    private static long hash32(BufferedInputStream inputStream, int length, boolean normalized) throws IOException {
        int read;
        int hash = 1 ^ length;
        int[] data = new int[4];
        while ((read = MurmurHash2.readNextBytes(data, inputStream, normalized)) == 4) {
            int k = data[0] | data[1] << 8 | data[2] << 16 | data[3] << 24;
            k = (int)((long)k * 1540483477L);
            k ^= k >>> 24;
            k = (int)((long)k * 1540483477L);
            hash = (int)((long)hash * 1540483477L);
            hash ^= k;
        }
        switch (read) {
            case 3: {
                hash ^= data[2] << 16;
            }
            case 2: {
                hash ^= data[1] << 8;
            }
            case 1: {
                hash ^= data[0];
                hash = (int)((long)hash * 1540483477L);
            }
        }
        hash ^= hash >>> 13;
        hash = (int)((long)hash * 1540483477L);
        hash ^= hash >>> 15;
        return Integer.toUnsignedLong(hash);
    }

    private static int readNextBytes(int[] out, BufferedInputStream is, boolean normalized) throws IOException {
        int readBytes = 0;
        while (readBytes < 4) {
            int next = is.read();
            if (next == -1) {
                return readBytes;
            }
            if (normalized && (next == 9 || next == 10 || next == 13 || next == 32)) continue;
            out[readBytes] = next;
            ++readBytes;
        }
        return readBytes;
    }

    private static int countMatchingBytes(BufferedInputStream is, boolean normalized) throws IOException {
        int read;
        if (!normalized) {
            return is.available();
        }
        int count = 0;
        while ((read = is.read()) != -1) {
            if (read == 9 || read == 10 || read == 13 || read == 32) continue;
            ++count;
        }
        return count;
    }
}

