/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.options;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OptionsFile {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern LINE_PATTERN = Pattern.compile("^(.+?):(.+)$");
    private final Map<String, String> options = new LinkedHashMap<String, String>();
    private final File file;

    public OptionsFile(File file) {
        this.file = Objects.requireNonNull(file);
    }

    public File getFile() {
        return this.file;
    }

    public String get(String key) {
        return this.options.get(key);
    }

    public void set(String key, String value) {
        this.options.put(key, value);
    }

    public void clear() {
        this.options.clear();
    }

    public void fill(Map<String, String> map) {
        this.options.putAll(map);
    }

    public Map<String, String> copy() {
        return new LinkedHashMap<String, String>(this.options);
    }

    public void read() throws IOException {
        this.clear();
        if (this.file.length() > 0x100000L) {
            throw new IOException("reported file size is incredibly large: " + this.file.length());
        }
        try (FileInputStream in = new FileInputStream(this.file);
             Scanner scanner = new Scanner(in);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Matcher m = LINE_PATTERN.matcher(line);
                if (m.matches()) {
                    this.options.put(m.group(1), m.group(2));
                    continue;
                }
                LOGGER.warn("Line skipped while parsing {}: {}", (Object)this.file, (Object)line);
            }
        }
    }

    public void save() throws IOException {
        try (FileWriter writer = new FileWriter(this.file);){
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                writer.append(entry.getKey()).append(':').append(entry.getValue()).append(System.lineSeparator());
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("file", (Object)this.file.getAbsolutePath()).append("fileExist", this.file.isFile()).append("options", this.options).build();
    }
}

