/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;

public class VersionFamily {
    private static final Map<String, Guess> ID_CACHE = new ConcurrentHashMap<String, Guess>();

    public static Guess guessFamilyOf(VersionSyncInfo versionSyncInfo) {
        if (versionSyncInfo.getLocalCompleteVersion() != null) {
            return new Guess(versionSyncInfo.getLocalCompleteVersion().getFamily(), true);
        }
        String id = versionSyncInfo.getAvailableVersion().getID();
        Guess maybeCached = ID_CACHE.get(id);
        if (maybeCached != null) {
            return maybeCached;
        }
        Guess guess = VersionFamily.doGuess(versionSyncInfo, id);
        if (guess != null) {
            ID_CACHE.put(id, guess);
        }
        return guess;
    }

    private static Guess doGuess(VersionSyncInfo versionSyncInfo, String id) {
        switch (versionSyncInfo.getAvailableVersion().getReleaseType()) {
            case UNKNOWN: 
            case OLD_ALPHA: 
            case SNAPSHOT: {
                return new Guess(versionSyncInfo.getAvailableVersion().getReleaseType().toString(), true);
            }
        }
        if (id.toLowerCase(Locale.ROOT).contains("forge")) {
            return new Guess("Forge-???", false);
        }
        if (id.toLowerCase(Locale.ROOT).contains("fabric")) {
            return new Guess("Fabric-???", false);
        }
        String family = CompleteVersion.getFamilyOf(id);
        return family == null ? null : new Guess(family, true);
    }

    public static class Guess {
        private final String family;
        private final boolean confident;

        public Guess(String family, boolean confident) {
            this.family = family;
            this.confident = confident;
        }

        public String getFamily() {
            return this.family;
        }

        public boolean isConfident() {
            return this.confident;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Guess guess = (Guess)o;
            return this.confident == guess.confident && this.family.equals(guess.family);
        }

        public int hashCode() {
            return Objects.hash(this.family, this.confident);
        }

        public String toString() {
            return "Guess{family='" + this.family + '\'' + ", confident=" + this.confident + '}';
        }
    }
}

