/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.turikhay.util.OS;

public class Rule {
    private final Action action;
    private OSRestriction os;
    private Map<String, Object> features;

    public Rule() {
        this.action = Action.ALLOW;
    }

    public Rule(Rule rule) {
        this.action = rule.action;
        if (rule.os != null) {
            this.os = new OSRestriction(rule.os);
        }
        if (rule.features != null) {
            this.features = rule.features;
        }
    }

    public Action getAppliedAction(FeatureMatcher featureMatcher) {
        if (this.os != null && !this.os.isCurrentOperatingSystem()) {
            return null;
        }
        if (this.features != null) {
            if (featureMatcher == null) {
                return null;
            }
            for (Map.Entry<String, Object> feature : this.features.entrySet()) {
                if (featureMatcher.hasFeature(feature.getKey(), feature.getValue())) continue;
                return null;
            }
        }
        return this.action;
    }

    public String toString() {
        return "Rule{action=" + (Object)((Object)this.action) + ", os=" + this.os + '}';
    }

    public static enum Action {
        ALLOW,
        DISALLOW;

    }

    public static class OSRestriction {
        private OS name;
        private String version;

        public OSRestriction() {
        }

        public OSRestriction(OSRestriction osRestriction) {
            this.name = osRestriction.name;
            this.version = osRestriction.version;
        }

        public boolean isCurrentOperatingSystem() {
            if (this.name != null && this.name != OS.CURRENT) {
                return false;
            }
            if (this.version != null) {
                try {
                    Pattern pattern = Pattern.compile(this.version);
                    Matcher matcher = pattern.matcher(System.getProperty("os.version"));
                    if (!matcher.matches()) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }

        public String toString() {
            return "OSRestriction{name=" + (Object)((Object)this.name) + ", version='" + this.version + '\'' + '}';
        }
    }

    public static interface FeatureMatcher {
        public boolean hasFeature(String var1, Object var2);
    }
}

