/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import net.minecraft.launcher.versions.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.repository.Repository;

public enum ReleaseType {
    RELEASE("release", false, true),
    SNAPSHOT("snapshot", true, true),
    MODIFIED("modified", true, true),
    OLD_BETA("old-beta", true, false),
    OLD_ALPHA("old-alpha", true, false),
    LAUNCHER("launcher", true, false),
    PENDING("pending", true, true),
    UNKNOWN("unknown", false, false);

    private static final Logger LOGGER;
    private static final Map<String, ReleaseType> lookup;
    private static final List<ReleaseType> defaultTypes;
    private static final List<ReleaseType> definableTypes;
    private final String name;
    private final boolean isDefinable;
    private final boolean isDefault;
    private static final Collection<ReleaseType> VALUES;

    @Nullable
    public static ReleaseType parse(String name) {
        return VALUES.stream().filter(e -> e.name().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    private ReleaseType(String name, boolean isDefinable, boolean isDefault) {
        this.name = name;
        this.isDefinable = isDefinable;
        this.isDefault = isDefault;
    }

    String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isDefinable() {
        return this.isDefinable;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    public static ReleaseType getByName(String name) {
        return lookup.get(name);
    }

    public static Collection<ReleaseType> valuesCollection() {
        return lookup.values();
    }

    public static List<ReleaseType> getDefault() {
        return defaultTypes;
    }

    public static List<ReleaseType> getDefinable() {
        return definableTypes;
    }

    public static ReleaseType of(String input) {
        ReleaseType value = ReleaseType.parse(input);
        return value == null ? UNKNOWN : value;
    }

    static {
        LOGGER = LogManager.getLogger();
        VALUES = Arrays.asList(ReleaseType.values());
        HashMap<String, ReleaseType> types = new HashMap<String, ReleaseType>(ReleaseType.values().length);
        ArrayList<ReleaseType> deflTypes = new ArrayList<ReleaseType>();
        ArrayList<ReleaseType> defnTypes = new ArrayList<ReleaseType>();
        for (ReleaseType type : ReleaseType.values()) {
            types.put(type.getName(), type);
            if (type.isDefault()) {
                deflTypes.add(type);
            }
            if (!type.isDefinable()) continue;
            defnTypes.add(type);
        }
        lookup = Collections.unmodifiableMap(types);
        defaultTypes = Collections.unmodifiableList(deflTypes);
        definableTypes = Collections.unmodifiableList(defnTypes);
    }

    public static enum SubType {
        OLD_RELEASE("old_release"){
            private final Date marker;
            {
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                calendar.set(2014, 4, 14, 0, 0);
                this.marker = calendar.getTime();
            }

            @Override
            public boolean isSubType(Version version) {
                if (version.getReleaseType().toString().startsWith("old")) {
                    return false;
                }
                Date date = version.getReleaseTime();
                if (date == null) {
                    LOGGER.warn("release time null: {}", (Object)version.getID());
                    return false;
                }
                if (date.getTime() <= 0L) {
                    if (StringUtils.containsIgnoreCase((CharSequence)version.getID(), (CharSequence)"forge")) {
                        date = version.getUpdatedTime();
                    } else {
                        return false;
                    }
                }
                return date.before(this.marker);
            }
        }
        ,
        REMOTE("remote"){

            @Override
            public boolean isSubType(Version version) {
                return version.getSource() != Repository.LOCAL_VERSION_REPO;
            }
        };

        private static final Map<String, SubType> lookup;
        private static final List<SubType> defaultSubTypes;
        private final String name;
        private final boolean isDefault;

        private SubType(String name, boolean isDefault) {
            this.name = name;
            this.isDefault = isDefault;
        }

        private SubType(String name) {
            this(name, true);
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static SubType getByName(String name) {
            return lookup.get(name);
        }

        public static Collection<SubType> valuesCollection() {
            return lookup.values();
        }

        public static List<SubType> getDefault() {
            return defaultSubTypes;
        }

        public static List<SubType> get(Version version) {
            ArrayList<SubType> result = new ArrayList<SubType>();
            for (SubType subType : SubType.values()) {
                if (!subType.isSubType(version)) continue;
                result.add(subType);
            }
            return result;
        }

        public abstract boolean isSubType(Version var1);

        static {
            HashMap<String, SubType> subTypes = new HashMap<String, SubType>(SubType.values().length);
            ArrayList<SubType> defSubTypes = new ArrayList<SubType>();
            for (SubType subType : SubType.values()) {
                subTypes.put(subType.getName(), subType);
                if (!subType.isDefault()) continue;
                defSubTypes.add(subType);
            }
            lookup = Collections.unmodifiableMap(subTypes);
            defaultSubTypes = Collections.unmodifiableList(defSubTypes);
        }
    }
}

