/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import java.util.HashMap;

public enum ModpackType {
    FORGE_LEGACY("legacy"),
    FORGE_LEGACY_ABSOLUTE("1.12.2_bug"),
    FORGE_1_13("aquatic"),
    NONE("none");

    private final String name;
    private static final HashMap<String, ModpackType> list;
    private static final Version version_1_13;
    private static final Version version_1_12_2;
    private static final Version version_1_7_10;

    private ModpackType(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static ModpackType getByName(String name, String version) {
        return list.getOrDefault(name, ModpackType.getByVersion(version));
    }

    private static ModpackType getByVersion(String version) {
        Version semVer;
        if (version == null) {
            return NONE;
        }
        if (version.matches("^\\d\\.\\d+$")) {
            version = version + ".0";
        }
        try {
            semVer = Version.valueOf((String)version);
        }
        catch (ParseException e) {
            return NONE;
        }
        if (semVer.greaterThanOrEqualTo(version_1_13)) {
            return FORGE_1_13;
        }
        if (semVer.equals((Object)version_1_12_2)) {
            return FORGE_LEGACY_ABSOLUTE;
        }
        if (semVer.greaterThanOrEqualTo(version_1_7_10)) {
            return FORGE_LEGACY;
        }
        return NONE;
    }

    static {
        list = new HashMap(ModpackType.values().length);
        for (ModpackType value : ModpackType.values()) {
            list.put(value.name, value);
        }
        version_1_13 = Version.valueOf((String)"1.13.0");
        version_1_12_2 = Version.valueOf((String)"1.12.2");
        version_1_7_10 = Version.valueOf((String)"1.7.10");
    }
}

