/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.HashMap;

public enum LibraryType {
    LIBRARY("library"),
    MODIFICATION("mod"),
    TRANSFORMER("forge_transformer"),
    DOWNLOAD_ONLY("download_only");

    private final String name;
    private static final HashMap<String, LibraryType> list;

    private LibraryType(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static LibraryType getByName(String name) {
        return list.getOrDefault(name, LIBRARY);
    }

    static {
        list = new HashMap(LibraryType.values().length);
        for (LibraryType value : LibraryType.values()) {
            list.put(value.name, value);
        }
    }
}

