/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.Rule;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.OS;

public class LibraryReplace
extends Library {
    private Pattern replaces;
    private String args;
    private String mainClass;
    private final List<Library> requires = new ArrayList<Library>();
    private final List<String> supports = new ArrayList<String>();

    public LibraryReplace() {
        this.url = "/libraries/";
    }

    public Pattern getPattern() {
        return this.replaces;
    }

    public boolean replaces(Library lib) {
        return this.replaces != null && this.replaces.matcher(Objects.requireNonNull(lib, "lib").getName()).matches();
    }

    public String getArgs() {
        return this.args;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<Library> getRequirementList() {
        return this.requires;
    }

    public List<String> getSupportedList() {
        return this.supports;
    }

    public boolean supports(String version) {
        return this.supports.contains(version);
    }

    @Override
    public Downloadable getDownloadable(Repository versionSource, Rule.FeatureMatcher featureMatcher, File file, OS os) {
        return super.getDownloadable(Repository.EXTRA_VERSION_REPO, featureMatcher, file, os);
    }

    public ToStringBuilder toStringBuilder() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("replaces", (Object)this.replaces).append("args", (Object)this.args).append("requires", this.requires).append("supports", this.supports);
    }

    @Override
    public final String toString() {
        return this.toStringBuilder().toString();
    }
}

