/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.launcher.updater.DownloadInfo;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.LibraryDownloadInfo;
import net.minecraft.launcher.versions.LibraryType;
import net.minecraft.launcher.versions.Rule;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.text.StrSubstitutor;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Sha1Downloadable;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.OS;

public class Library {
    protected static final StrSubstitutor SUBSTITUTOR;
    protected String name;
    protected List<Rule> rules;
    protected Map<OS, String> natives;
    protected ExtractRules extract;
    protected String url;
    protected String exact_url;
    protected String checksum;
    protected List<String> deleteEntries;
    protected LibraryDownloadInfo downloads;
    protected Boolean mod;
    protected Boolean downloadOnly;
    protected String type;

    public Library() {
    }

    public Library(String name, String url, String checksum) {
        this.name = name;
        this.url = url;
        this.checksum = checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Library library = (Library)o;
        return new EqualsBuilder().append((Object)this.name, (Object)library.name).append(this.rules, library.rules).append(this.natives, library.natives).append((Object)this.extract, (Object)library.extract).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.rules).append(this.natives).append((Object)this.extract).toHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getPlainName() {
        String[] split = this.name.split(":", 3);
        if (split.length < 3) {
            throw new IllegalArgumentException("bad library: " + this.name);
        }
        return split[0] + "." + split[1];
    }

    public List<Rule> getRules() {
        return this.rules == null ? null : Collections.unmodifiableList(this.rules);
    }

    public boolean appliesToCurrentEnvironment(Rule.FeatureMatcher featureMatcher) {
        if (this.rules == null) {
            return true;
        }
        Rule.Action lastAction = Rule.Action.DISALLOW;
        for (Rule compatibilityRule : this.rules) {
            Rule.Action action = compatibilityRule.getAppliedAction(featureMatcher);
            if (action == null) continue;
            lastAction = action;
        }
        return lastAction == Rule.Action.ALLOW;
    }

    public Map<OS, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtractRules() {
        return this.extract;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public List<String> getDeleteEntriesList() {
        return this.deleteEntries;
    }

    public LibraryType getLibraryType() {
        if (this.type == null) {
            if (this.mod != null && this.mod.booleanValue()) {
                return LibraryType.MODIFICATION;
            }
            if (this.downloadOnly != null && this.downloadOnly.booleanValue()) {
                return LibraryType.DOWNLOAD_ONLY;
            }
            return LibraryType.LIBRARY;
        }
        return LibraryType.getByName(this.type);
    }

    String getArtifactBaseDir() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact dir of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 4);
        if (parts.length < 3) {
            throw new IllegalArgumentException("bad library name: " + this.name);
        }
        return String.format(Locale.ROOT, "%s/%s/%s", parts[0].replaceAll("\\.", "/"), parts[1], parts[2]);
    }

    public String getArtifactPath() {
        return this.getArtifactPath(null);
    }

    public String getArtifactPath(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format(Locale.ROOT, "%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename(classifier));
    }

    String getArtifactFilename(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 4);
        String result = classifier == null ? (parts.length == 4 ? String.format(Locale.ROOT, "%s-%s-%s.jar", parts[1], parts[2], parts[3]) : String.format(Locale.ROOT, "%s-%s.jar", parts[1], parts[2])) : String.format(Locale.ROOT, "%s-%s-%s.jar", parts[1], parts[2], classifier);
        return SUBSTITUTOR.replace(result);
    }

    public boolean hasEmptyUrl() {
        return this.downloads != null && this.downloads.getArtifact() != null && StringUtils.isEmpty((CharSequence)this.downloads.getArtifact().getUrl());
    }

    public String toString() {
        return "Library{name=\"" + this.name + "\", rules=" + this.rules + ", natives=" + this.natives + ", extract=" + this.extract + ", mod=" + this.mod + ", downloadOnly=\"+" + this.downloadOnly + "\"}";
    }

    public Downloadable getDownloadable(Repository versionSource, Rule.FeatureMatcher featureMatcher, File file, OS os) {
        Repository repo;
        String path;
        DownloadInfo info;
        String classifier;
        String string = classifier = this.natives != null && this.appliesToCurrentEnvironment(featureMatcher) ? this.natives.get((Object)os) : null;
        if (this.downloads != null && (info = this.downloads.getDownloadInfo(SUBSTITUTOR.replace(classifier))) != null) {
            return new LibraryDownloadable(info, file);
        }
        if (this.exact_url == null) {
            path = this.getArtifactPath(classifier);
            if (this.url == null) {
                repo = Repository.LIBRARY_REPO;
            } else if (this.url.startsWith("/")) {
                repo = versionSource == null ? Repository.EXTRA_VERSION_REPO : versionSource;
                path = this.url.substring(1) + path;
            } else {
                repo = Repository.PROXIFIED_REPO;
                path = this.url + path;
            }
        } else {
            repo = Repository.PROXIFIED_REPO;
            path = this.exact_url;
        }
        return new LibraryDownloadable(repo, path, file);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("platform", OS.CURRENT.getName());
        map.put("arch", OS.Arch.IS_64_BIT ? "64" : "32");
        SUBSTITUTOR = new StrSubstitutor(map);
    }

    public class LibraryDownloadable
    extends Sha1Downloadable {
        private LibraryDownloadable(Repository repo, String path, File file) {
            super(repo, path, file);
            this.sha1 = Library.this.getChecksum();
        }

        private LibraryDownloadable(String path, File file) {
            super(Repository.PROXIFIED_REPO, path, file);
            this.sha1 = Library.this.getChecksum();
        }

        public LibraryDownloadable(DownloadInfo info, File file) {
            super(info.getUrl().startsWith("/") ? Repository.EXTRA_VERSION_REPO : Repository.PROXIFIED_REPO, info.getUrl(), file);
            this.sha1 = info.getSha1();
            this.length = info.getSize();
        }

        public Library getDownloadableLibrary() {
            return Library.this;
        }

        public Library getLibrary() {
            return Library.this;
        }
    }
}

