/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.launcher.updater.AssetIndexInfo;
import net.minecraft.launcher.updater.DownloadInfo;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.Argument;
import net.minecraft.launcher.versions.ArgumentType;
import net.minecraft.launcher.versions.CurrentLaunchFeatureMatcher;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.LibraryType;
import net.minecraft.launcher.versions.ModpackType;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.OS;
import ru.turikhay.util.json.ExposeExclusion;

public class CompleteVersion
implements Version,
Cloneable {
    private static final Logger LOGGER = LogManager.getLogger();
    String id;
    String jar;
    String url;
    String family;
    String inheritsFrom;
    Date time;
    Date releaseTime;
    String type;
    String jvmArguments;
    String minecraftArguments;
    String mainClass;
    Integer minimumLauncherVersion = 0;
    Integer tlauncherVersion = 0;
    List<Library> libraries;
    List<Rule> rules;
    List<String> deleteEntries;
    Map<String, DownloadInfo> downloads = new HashMap<String, DownloadInfo>();
    AssetIndexInfo assetIndex;
    String assets;
    Map<ArgumentType, List<Argument>> arguments;
    Boolean modListAbsolutePrefix;
    String modpack;
    JavaVersion javaVersion;
    Map<String, LoggingConfiguration> logging;
    @Expose
    Repository source;
    @Expose
    final Set<String> proceededFor = new HashSet<String>();
    @Expose
    VersionList list;
    public static final String FORGE_PREFIX = "Forge-";
    public static final String FABRIC_PREFIX = "Fabric-";
    protected static final Pattern familyPattern = Pattern.compile("([a-z]*[\\d]\\.[\\d]+).*");

    public CompleteVersion() {
    }

    public CompleteVersion(String id, String minecraftArguments, String mainClass, String assets, String jar, Date time, Date releaseTime, Integer minimumLauncherVersion, List<Library> libraries) {
        this.id = id;
        this.minecraftArguments = minecraftArguments;
        this.mainClass = mainClass;
        this.assets = assets;
        this.jar = jar;
        this.time = time;
        this.releaseTime = releaseTime;
        this.minimumLauncherVersion = minimumLauncherVersion;
        this.libraries = libraries;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID is NULL or empty");
        }
        this.id = id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    @Override
    public ReleaseType getReleaseType() {
        return ReleaseType.of(this.type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Repository getSource() {
        return this.source;
    }

    @Override
    public void setSource(Repository repository) {
        if (repository == null) {
            throw new NullPointerException();
        }
        this.source = repository;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    public void setUpdatedTime(Date time) {
        if (time == null) {
            throw new NullPointerException("Time is NULL!");
        }
        this.time = time;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    @Override
    public VersionList getVersionList() {
        return this.list;
    }

    @Override
    public void setVersionList(VersionList list) {
        if (list == null) {
            throw new NullPointerException("VersionList cannot be NULL!");
        }
        this.list = list;
    }

    public ModpackType getModpackType() {
        if (this.modListAbsolutePrefix != null && this.modListAbsolutePrefix.booleanValue()) {
            return ModpackType.FORGE_LEGACY_ABSOLUTE;
        }
        return ModpackType.getByName(this.modpack, this.jar);
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public String getJar() {
        return this.jar;
    }

    public String getInheritsFrom() {
        return this.inheritsFrom;
    }

    public String getJVMArguments() {
        return this.jvmArguments;
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public void setMinecraftArguments(String args) {
        this.minecraftArguments = args;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String clazz) {
        this.mainClass = clazz;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<String> getDeleteEntries() {
        return this.deleteEntries;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public int getMinimumCustomLauncherVersion() {
        return this.tlauncherVersion;
    }

    public AssetIndexInfo getAssetIndex() {
        if (this.assetIndex == null) {
            this.assetIndex = this.assets == null ? new AssetIndexInfo("legacy") : new AssetIndexInfo(this.assets);
        }
        return this.assetIndex;
    }

    public DownloadInfo getDownloadURL(String type) {
        return this.downloads.get(type);
    }

    public boolean isProceededFor(String type) {
        return this.proceededFor.contains(type);
    }

    public void setProceededFor(String type) {
        this.proceededFor.add(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.hashCode() == o.hashCode()) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version compare = (Version)o;
        return compare.getID() != null && compare.getID().equals(this.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.debugString();
    }

    public String debugString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("jar", (Object)this.jar).append("inheritsFrom", (Object)this.inheritsFrom).append("url", (Object)this.url).append("time", (Object)this.time).append("releaseTime", (Object)this.releaseTime).append("downloads", this.downloads).append("assetIndex", (Object)this.assetIndex).append("source", (Object)this.source).append("list", (Object)this.list).append("libraries", this.libraries == null ? null : "(" + this.libraries.size() + " items)").build();
    }

    public File getFile(File base) {
        return new File(base, "versions/" + this.getID() + "/" + this.getID() + ".jar");
    }

    public boolean appliesToCurrentEnvironment(Rule.FeatureMatcher matcher) {
        if (this.rules != null) {
            for (Rule rule : this.rules) {
                Rule.Action action = rule.getAppliedAction(matcher);
                if (action != Rule.Action.DISALLOW) continue;
                return false;
            }
        }
        return true;
    }

    public Collection<Library> getRelevantLibraries(Rule.FeatureMatcher matcher) {
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library library : this.libraries) {
            if (!library.appliesToCurrentEnvironment(matcher)) continue;
            result.add(library);
        }
        return result;
    }

    private Stream<Library> streamLibraries(LibraryType type, Rule.FeatureMatcher matcher) {
        return this.getRelevantLibraries(matcher).stream().filter(lib -> lib.getLibraryType() == type);
    }

    public Collection<File> getClassPath(OS os, Rule.FeatureMatcher matcher, File base) {
        List<File> result = this.streamLibraries(LibraryType.LIBRARY, matcher).filter(lib -> lib.getNatives() == null).map(lib -> new File(base, "libraries/" + lib.getArtifactPath())).collect(Collectors.toList());
        result.add(this.getJarFile(base));
        return result;
    }

    public File getJarFile(File base) {
        return new File(base, "versions/" + this.getID() + "/" + this.getID() + ".jar");
    }

    public List<Library> getMods(Rule.FeatureMatcher matcher) {
        return this.streamLibraries(LibraryType.MODIFICATION, matcher).collect(Collectors.toList());
    }

    public List<Library> getTransformers(Rule.FeatureMatcher matcher) {
        return this.streamLibraries(LibraryType.TRANSFORMER, matcher).collect(Collectors.toList());
    }

    public Collection<File> getClassPath(Rule.FeatureMatcher matcher, File base) {
        return this.getClassPath(OS.CURRENT, matcher, base);
    }

    public Collection<String> getNatives(OS os, Rule.FeatureMatcher matcher) {
        Collection<Library> libraries = this.getRelevantLibraries(matcher);
        ArrayList<String> result = new ArrayList<String>();
        for (Library library : libraries) {
            Map<OS, String> natives = library.getNatives();
            if (natives == null || !natives.containsKey((Object)os)) continue;
            result.add("libraries/" + library.getArtifactPath(natives.get((Object)os)));
        }
        return result;
    }

    public Collection<String> getNatives(Rule.FeatureMatcher matcher) {
        return this.getNatives(OS.CURRENT, matcher);
    }

    public Set<String> getRequiredFiles(OS os, Rule.FeatureMatcher matcher) {
        HashSet<String> neededFiles = new HashSet<String>();
        for (Library library : this.getRelevantLibraries(matcher)) {
            if (library.getNatives() != null) {
                String natives = library.getNatives().get((Object)os);
                if (natives == null) continue;
                neededFiles.add("libraries/" + library.getArtifactPath(natives));
                continue;
            }
            neededFiles.add("libraries/" + library.getArtifactPath());
        }
        return neededFiles;
    }

    public Collection<String> getExtractFiles(OS os, Rule.FeatureMatcher matcher) {
        return this.getRelevantLibraries(matcher).stream().filter(lib -> lib.getNatives() != null).filter(lib -> lib.getNatives().containsKey((Object)os)).map(lib -> "libraries/" + lib.getArtifactPath(lib.getNatives().get((Object)os))).collect(Collectors.toList());
    }

    public CompleteVersion resolve(VersionManager vm, boolean useLatest) throws IOException {
        return this.resolve(vm, useLatest, new ArrayList<String>());
    }

    protected void resolveFamily(String parent_family) {
        if (this.family != null) {
            return;
        }
        if (parent_family == null) {
            parent_family = "unknown";
        }
        if (parent_family.startsWith(FORGE_PREFIX) || parent_family.startsWith(FABRIC_PREFIX)) {
            this.family = parent_family;
            return;
        }
        if (this.id.toLowerCase(Locale.ROOT).contains("forge")) {
            this.family = FORGE_PREFIX + parent_family;
            return;
        }
        if (this.id.toLowerCase(Locale.ROOT).contains("fabric")) {
            this.family = FABRIC_PREFIX + parent_family;
            return;
        }
        this.family = parent_family;
    }

    public CompleteVersion resolve(VersionManager vm, boolean useLatest, List<String> inheritance) throws IOException {
        if (vm == null) {
            throw new NullPointerException("version manager");
        }
        if (this.inheritsFrom == null) {
            if (this.family == null || this.family.equals(FORGE_PREFIX) || this.family.equals(FABRIC_PREFIX)) {
                String family_;
                switch (this.getReleaseType()) {
                    case UNKNOWN: 
                    case OLD_ALPHA: 
                    case SNAPSHOT: {
                        family_ = this.type;
                        break;
                    }
                    default: {
                        family_ = CompleteVersion.getFamilyOf(this.id);
                        if (family_ == null && this.jar != null) {
                            family_ = CompleteVersion.getFamilyOf(this.jar);
                        }
                        if (family_ != null || this.inheritsFrom == null) break;
                        family_ = CompleteVersion.getFamilyOf(this.inheritsFrom);
                    }
                }
                if (family_ == null) {
                    family_ = "unknown";
                }
                this.resolveFamily(family_);
            }
            return this.clone();
        }
        if (inheritance.contains(this.id)) {
            throw new DuplicateInheritanceException();
        }
        if (this.jar == null) {
            this.jar = this.inheritsFrom;
        }
        inheritance.add(this.id);
        VersionSyncInfo parentSyncInfo = vm.getVersionSyncInfo(this.inheritsFrom, inheritance);
        if (parentSyncInfo == null) {
            throw new ParentNotFoundException();
        }
        CompleteVersion result = parentSyncInfo.getCompleteVersion(useLatest).resolve(vm, useLatest, inheritance);
        this.resolveFamily(result.family);
        return this.copyInto(result);
    }

    public CompleteVersion copyInto(CompleteVersion result) {
        result.id = this.id;
        if (this.jar != null) {
            result.jar = this.jar;
        }
        if (this.family != null) {
            result.family = this.family;
        }
        result.inheritsFrom = null;
        if (result.modListAbsolutePrefix == null || !result.modListAbsolutePrefix.booleanValue()) {
            result.modListAbsolutePrefix = this.modListAbsolutePrefix;
        }
        if ((result.releaseTime == null || result.releaseTime.getTime() == 0L) && this.releaseTime != null) {
            result.releaseTime = this.releaseTime;
        }
        if (this.time != null && this.time.getTime() != 0L) {
            result.time = this.time;
        }
        if (this.type != null) {
            result.type = this.type;
        }
        if (this.modpack != null) {
            result.modpack = this.modpack;
        }
        if (this.jvmArguments != null) {
            result.jvmArguments = this.jvmArguments;
        }
        if (this.minecraftArguments != null) {
            result.minecraftArguments = this.minecraftArguments;
        }
        if (this.mainClass != null) {
            result.mainClass = this.mainClass;
        }
        if (this.libraries != null) {
            LinkedHashSet<Library> lib = new LinkedHashSet<Library>(this.libraries);
            if (result.libraries != null) {
                lib.addAll(result.libraries);
            }
            result.libraries = new ArrayList<Library>();
            result.libraries.addAll(lib);
        }
        if (this.arguments != null) {
            if (result.arguments == null) {
                result.arguments = new EnumMap<ArgumentType, List<Argument>>(ArgumentType.class);
            }
            for (Map.Entry<ArgumentType, List<Argument>> entry : this.arguments.entrySet()) {
                List arguments = result.arguments.computeIfAbsent(entry.getKey(), k -> new ArrayList());
                arguments.addAll((Collection)entry.getValue());
            }
        }
        if (this.rules != null) {
            if (result.rules != null) {
                result.rules.addAll(this.rules);
            } else {
                result.rules = new ArrayList<Rule>(this.rules);
            }
        }
        if (this.deleteEntries != null) {
            if (result.deleteEntries != null) {
                result.deleteEntries.addAll(this.deleteEntries);
            } else {
                result.deleteEntries = new ArrayList<String>(this.deleteEntries);
            }
        }
        if (this.minimumLauncherVersion != 0) {
            result.minimumLauncherVersion = this.minimumLauncherVersion;
        }
        if (this.tlauncherVersion != 0) {
            result.tlauncherVersion = this.tlauncherVersion;
        }
        if (this.assetIndex != null) {
            result.assetIndex = this.assetIndex;
        }
        if (this.downloads != null && this.downloads.size() > 0) {
            result.downloads = this.downloads;
        }
        if (this.javaVersion != null) {
            result.javaVersion = this.javaVersion;
        }
        if (this.source != null) {
            result.source = this.source;
        }
        if (this.logging != null) {
            result.logging = this.logging;
        }
        result.list = this.list;
        return result;
    }

    public Rule.FeatureMatcher createFeatureMatcher() {
        return new CurrentLaunchFeatureMatcher();
    }

    public boolean hasModernArguments() {
        return this.arguments != null;
    }

    public List<String> addArguments(ArgumentType type, Rule.FeatureMatcher featureMatcher, StrSubstitutor substitutor) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.arguments != null) {
            List<Argument> args = this.arguments.get((Object)type);
            if (args != null) {
                for (Argument argument : args) {
                    result.addAll(argument.apply(featureMatcher, substitutor));
                }
            }
        } else if (this.minecraftArguments != null) {
            if (type == ArgumentType.GAME) {
                for (String arg : this.minecraftArguments.split(" ")) {
                    result.add(substitutor.replace(arg));
                }
                if (featureMatcher.hasFeature("is_demo_user", Boolean.TRUE)) {
                    result.add("--demo");
                }
                if (featureMatcher.hasFeature("has_custom_resolution", Boolean.TRUE)) {
                    result.addAll(Arrays.asList("--width", substitutor.replace("${resolution_width}"), "--height", substitutor.replace("${resolution_height}")));
                }
            } else if (type == ArgumentType.JVM) {
                result.add("-Dfml.ignoreInvalidMinecraftCertificates=true");
                result.add("-Dfml.ignorePatchDiscrepancies=true");
                result.add("-Djava.net.useSystemProxies=true");
                if (OS.WINDOWS.isCurrent()) {
                    result.add("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
                    if (OS.VERSION.startsWith("10.")) {
                        result.addAll(Arrays.asList("-Dos.name=Windows 10", "-Dos.version=10.0"));
                    }
                } else if (OS.OSX.isCurrent()) {
                    result.addAll(Arrays.asList(substitutor.replace("-Xdock:icon=${asset=icons/minecraft.icns}"), "-Xdock:name=Minecraft"));
                }
                result.add(substitutor.replace("-Djava.library.path=${natives_directory}"));
                result.add(substitutor.replace("-Dminecraft.launcher.brand=${launcher_name}"));
                result.add(substitutor.replace("-Dminecraft.launcher.version=${launcher_version}"));
                result.add(substitutor.replace("-Dminecraft.client.jar=${primary_jar}"));
                result.addAll(Arrays.asList("-cp", substitutor.replace("${classpath}")));
            }
        }
        return result;
    }

    public Map<String, LoggingConfiguration> getLogging() {
        return this.logging;
    }

    public void validate() {
        Validate.notNull((Object)this.id, (String)"id", (Object[])new Object[0]);
        Validate.notNull((Object)this.type, (String)"type", (Object[])new Object[0]);
        Validate.notNull(this.libraries, (String)"libraries", (Object[])new Object[0]);
        Validate.notNull((Object)this.mainClass, (String)"mainClass", (Object[])new Object[0]);
    }

    public static String getFamilyOf(String id) {
        Matcher matcher = familyPattern.matcher(id);
        String family = matcher.matches() ? matcher.group(1) : null;
        return family;
    }

    public CompleteVersion clone() {
        CompleteVersion c;
        try {
            c = (CompleteVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.arguments != null) {
            c.arguments = new EnumMap<ArgumentType, List<Argument>>(ArgumentType.class);
            for (Map.Entry<ArgumentType, List<Argument>> argsList : this.arguments.entrySet()) {
                c.arguments.put(argsList.getKey(), new ArrayList(argsList.getValue()));
            }
        }
        return c;
    }

    public static class JavaVersion {
        private String component;
        private int majorVersion;

        public JavaVersion(String component, int majorVersion) {
            this.component = component;
            this.majorVersion = majorVersion;
        }

        public JavaVersion() {
        }

        public String getComponent() {
            return this.component;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public String toString() {
            return "JavaVersion{component='" + this.component + '\'' + ", majorVersion=" + this.majorVersion + '}';
        }
    }

    public class DuplicateInheritanceException
    extends InheritanceException {
    }

    public class ParentNotFoundException
    extends InheritanceException {
    }

    public static class LoggingDownloadInfo
    extends DownloadInfo {
        private String id;

        public String getId() {
            return this.id;
        }

        @Override
        public String toString() {
            return "LoggingDownloadInfo{url='" + this.url + '\'' + ", sha1='" + this.sha1 + '\'' + ", size=" + this.size + ", id='" + this.id + '\'' + '}';
        }
    }

    public static class LoggingConfiguration {
        private String argument;
        private LoggingDownloadInfo file;
        private String type;

        public String getArgument() {
            return this.argument;
        }

        public LoggingDownloadInfo getFile() {
            return this.file;
        }

        public String getType() {
            return this.type;
        }

        public boolean isValid() {
            return this.argument != null && this.file != null && "log4j2-xml".equals(this.type);
        }
    }

    public class InheritanceException
    extends IOException {
        InheritanceException() {
            super(CompleteVersion.this.id + " should inherit from " + CompleteVersion.this.inheritsFrom);
        }

        public String getID() {
            return CompleteVersion.this.id;
        }

        public String getInheritsFrom() {
            return CompleteVersion.this.inheritsFrom;
        }

        public CompleteVersion getVersion() {
            return CompleteVersion.this;
        }
    }

    public static class CompleteVersionSerializer
    implements JsonSerializer<CompleteVersion>,
    JsonDeserializer<CompleteVersion> {
        private final Gson defaultContext;

        public CompleteVersionSerializer() {
            GsonBuilder builder = new GsonBuilder();
            ExposeExclusion.setup(builder);
            builder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
            builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(true));
            builder.registerTypeAdapter(Argument.class, (Object)new Argument.Serializer());
            builder.enableComplexMapKeySerialization();
            builder.setPrettyPrinting();
            this.defaultContext = builder.create();
        }

        public CompleteVersion deserialize(JsonElement elem, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonElement unnecessaryEntries1;
            JsonObject object = elem.getAsJsonObject();
            JsonElement originalId = object.get("original_id");
            if (originalId != null && originalId.isJsonPrimitive()) {
                String unnecessaryEntries = originalId.getAsString();
                object.remove("original_id");
                object.addProperty("jar", unnecessaryEntries);
            }
            if ((unnecessaryEntries1 = object.get("unnecessaryEntries")) != null && unnecessaryEntries1.isJsonArray()) {
                object.remove("unnecessaryEntries");
                object.add("deleteEntries", unnecessaryEntries1);
            }
            CompleteVersion version = (CompleteVersion)this.defaultContext.fromJson(elem, CompleteVersion.class);
            if (version.id == null) {
                throw new JsonParseException("Version ID is NULL!");
            }
            if (version.type == null) {
                version.type = ReleaseType.UNKNOWN.getName();
            }
            if (version.source == null) {
                version.source = Repository.LOCAL_VERSION_REPO;
            }
            if (version.time == null) {
                version.time = new Date(0L);
            }
            if (version.libraries == null) {
                version.libraries = new ArrayList<Library>();
            }
            return version;
        }

        public JsonElement serialize(CompleteVersion version0, Type type, JsonSerializationContext context) {
            CompleteVersion version = version0.clone();
            JsonObject object = (JsonObject)this.defaultContext.toJsonTree((Object)version, type);
            JsonElement jar = object.get("jar");
            if (jar == null) {
                object.remove("downloadJarLibraries");
            }
            return object;
        }
    }
}

