/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launcher.versions.Rule;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.text.StrSubstitutor;

public class Argument {
    private final String[] value;
    private final List<Rule> compatibilityRules;

    public Argument(String[] values, List<Rule> Rules) {
        this.value = values;
        this.compatibilityRules = Rules;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("value", (Object[])this.value).append("compatibilityRules", this.compatibilityRules).build();
    }

    public List<String> apply(Rule.FeatureMatcher featureMatcher, StrSubstitutor substitutor) {
        ArrayList<String> output = new ArrayList<String>();
        if (this.appliesToCurrentEnvironment(featureMatcher)) {
            for (String value : this.value) {
                output.add(substitutor == null ? value : substitutor.replace(value));
            }
        }
        return output;
    }

    public boolean appliesToCurrentEnvironment(Rule.FeatureMatcher featureMatcher) {
        if (this.compatibilityRules == null) {
            return true;
        }
        Rule.Action lastAction = Rule.Action.DISALLOW;
        for (Rule Rule2 : this.compatibilityRules) {
            Rule.Action action = Rule2.getAppliedAction(featureMatcher);
            if (action == null) continue;
            lastAction = action;
        }
        return lastAction == Rule.Action.ALLOW;
    }

    public static class Serializer
    implements JsonDeserializer<Argument>,
    JsonSerializer<Argument> {
        public Argument deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new Argument(new String[]{json.getAsString()}, null);
            }
            if (json.isJsonObject()) {
                String[] values;
                JsonObject obj = json.getAsJsonObject();
                JsonElement rawValues = obj.has("values") ? obj.get("values") : obj.get("value");
                if (rawValues.isJsonPrimitive()) {
                    values = new String[]{rawValues.getAsString()};
                } else {
                    JsonArray array = rawValues.getAsJsonArray();
                    values = new String[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        values[i] = array.get(i).getAsString();
                    }
                }
                ArrayList<Rule> rules = null;
                if (obj.has("rules")) {
                    rules = new ArrayList<Rule>();
                    JsonArray array = obj.getAsJsonArray("rules");
                    for (JsonElement element : array) {
                        rules.add((Rule)context.deserialize(element, Rule.class));
                    }
                }
                return new Argument(values, rules);
            }
            throw new JsonParseException("Invalid argument, must be object or string");
        }

        public JsonElement serialize(Argument src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray array;
            JsonObject object = new JsonObject();
            if (src.value.length == 1) {
                object.addProperty("value", src.value[0]);
            } else {
                array = new JsonArray();
                for (String v : src.value) {
                    array.add(v);
                }
                object.add("value", (JsonElement)array);
            }
            if (src.compatibilityRules != null && !src.compatibilityRules.isEmpty()) {
                array = new JsonArray();
                for (Rule rule : src.compatibilityRules) {
                    array.add(context.serialize((Object)rule));
                }
                object.add("rules", (JsonElement)array);
            }
            return object;
        }
    }
}

