/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.Version;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;

public class VersionSyncInfo {
    protected Version localVersion;
    protected Version remoteVersion;
    private CompleteVersion completeLocal;
    private CompleteVersion completeRemote;
    private String id;

    public VersionSyncInfo(Version localVersion, Version remoteVersion) {
        if (localVersion == null && remoteVersion == null) {
            throw new NullPointerException("Cannot create sync info from NULLs!");
        }
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        if (localVersion != null && remoteVersion != null) {
            localVersion.setVersionList(remoteVersion.getVersionList());
        }
        if (this.getID() == null) {
            throw new NullPointerException("Cannot create sync info from versions that have NULL IDs");
        }
    }

    public VersionSyncInfo(VersionSyncInfo info) {
        this(info.getLocal(), info.getRemote());
    }

    protected VersionSyncInfo() {
        this.localVersion = null;
        this.remoteVersion = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getID() != null && o instanceof VersionSyncInfo) {
            VersionSyncInfo v = (VersionSyncInfo)o;
            return this.getID().equals(v.getID());
        }
        return false;
    }

    public Version getLocal() {
        return this.localVersion;
    }

    public void setLocal(Version version) {
        this.localVersion = version;
        if (version instanceof CompleteVersion) {
            this.completeLocal = (CompleteVersion)version;
        }
    }

    public Version getRemote() {
        return this.remoteVersion;
    }

    public void setRemote(Version version) {
        this.remoteVersion = version;
        if (version instanceof CompleteVersion) {
            this.completeRemote = (CompleteVersion)version;
        }
    }

    public String getID() {
        return this.id != null ? this.id : (this.localVersion != null ? this.localVersion.getID() : (this.remoteVersion != null ? this.remoteVersion.getID() : null));
    }

    public void setID(String id) {
        if (id != null && id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty!");
        }
        this.id = id;
    }

    public Version getLatestVersion() {
        return this.remoteVersion != null ? this.remoteVersion : this.localVersion;
    }

    public Version getAvailableVersion() {
        return this.localVersion != null ? this.localVersion : this.remoteVersion;
    }

    public boolean isInstalled() {
        return this.localVersion != null;
    }

    public boolean hasRemote() {
        return this.remoteVersion != null;
    }

    public boolean isUpToDate() {
        return this.localVersion != null && (this.remoteVersion == null || this.localVersion.getUpdatedTime().compareTo(this.remoteVersion.getUpdatedTime()) >= 0);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.getID() + "',\nlocal=" + this.localVersion + ",\nremote=" + this.remoteVersion + ", isInstalled=" + this.isInstalled() + ", hasRemote=" + this.hasRemote() + ", isUpToDate=" + this.isUpToDate() + "}";
    }

    public CompleteVersion resolveCompleteVersion(VersionManager manager, boolean latest) throws IOException {
        CompleteVersion complete;
        Version version = latest ? this.getLatestVersion() : (this.isInstalled() ? this.getLocal() : this.getRemote());
        if (version.equals(this.localVersion) && this.completeLocal != null && this.completeLocal.getInheritsFrom() == null) {
            return this.completeLocal;
        }
        if (version.equals(this.remoteVersion) && this.completeRemote != null && this.completeRemote.getInheritsFrom() == null) {
            return this.completeRemote;
        }
        try {
            complete = version.getVersionList().getCompleteVersion(version).resolve(manager, latest);
        }
        catch (JsonSyntaxException e) {
            throw new IOException("syntax error resolving " + version.getID(), e);
        }
        if (version == this.localVersion) {
            this.completeLocal = complete;
        } else if (version == this.remoteVersion) {
            this.completeRemote = complete;
        }
        return complete;
    }

    public CompleteVersion getCompleteVersion(boolean latest) throws IOException {
        Version version = latest ? this.getLatestVersion() : (this.isInstalled() ? this.getLocal() : this.getRemote());
        if (version.equals(this.localVersion) && this.completeLocal != null) {
            return this.completeLocal;
        }
        if (version.equals(this.remoteVersion) && this.completeRemote != null) {
            return this.completeRemote;
        }
        CompleteVersion complete = version.getVersionList().getCompleteVersion(version);
        if (version == this.localVersion) {
            this.completeLocal = complete;
        } else if (version == this.remoteVersion) {
            this.completeRemote = complete;
        }
        return complete;
    }

    public CompleteVersion getLatestCompleteVersion() throws IOException {
        return this.getCompleteVersion(true);
    }

    public CompleteVersion getLocalCompleteVersion() {
        if (this.completeLocal == null && this.localVersion instanceof CompleteVersion) {
            this.completeLocal = (CompleteVersion)this.localVersion;
        }
        return this.completeLocal;
    }

    Set<Downloadable> getRequiredDownloadables(OS os, Rule.FeatureMatcher featureMatcher, File targetDirectory, boolean force, Account.AccountType type, boolean firstIteration) throws IOException {
        Repository source;
        HashSet<Downloadable> neededFiles = new HashSet<Downloadable>();
        CompleteVersion version0 = this.getCompleteVersion(force);
        CompleteVersion version = type != null && !version0.isProceededFor(type.toString()) ? (firstIteration ? TLauncher.getInstance().getLibraryManager().processExplicitly(version0, type.toString()) : TLauncher.getInstance().getLibraryManager().process(version0, type.toString())) : version0;
        Repository repository = source = this.hasRemote() ? this.remoteVersion.getSource() : null;
        if (source != null && !source.isRemote()) {
            return neededFiles;
        }
        Collection<Library> libraries = version.getRelevantLibraries(featureMatcher);
        if (firstIteration) {
            neededFiles.addAll(this.getRequiredDownloadables(os, featureMatcher, targetDirectory, force, type, false));
        }
        if (type != Account.AccountType.PLAIN) {
            neededFiles.addAll(this.getRequiredDownloadables(os, featureMatcher, targetDirectory, force, Account.AccountType.PLAIN, false));
        }
        Iterator<Library> var9 = libraries.iterator();
        while (var9.hasNext()) {
            Library library = var9.next();
            String file = null;
            if (library.getNatives() != null) {
                String local = library.getNatives().get((Object)os);
                if (local != null) {
                    file = library.getArtifactPath(local);
                }
            } else {
                file = library.getArtifactPath();
            }
            if (file == null) continue;
            File local1 = new File(targetDirectory, "libraries/" + file);
            if (!force && local1.isFile() && (library.getChecksum() == null || library.getChecksum().equals(FileUtil.getChecksum(local1, "SHA-1"))) || library.hasEmptyUrl()) continue;
            neededFiles.add(library.getDownloadable(source, featureMatcher, local1, os));
        }
        return neededFiles;
    }

    public Set<Downloadable> getRequiredDownloadables(Rule.FeatureMatcher featureMatcher, File targetDirectory, boolean force, Account.AccountType type) throws IOException {
        return this.getRequiredDownloadables(OS.CURRENT, featureMatcher, targetDirectory, force, type, true);
    }

    public static VersionSyncInfo createEmpty() {
        return new VersionSyncInfo();
    }
}

