/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.launcher.updater.RawVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.PartialVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.repository.RepositoryProxy;
import ru.turikhay.util.OS;
import ru.turikhay.util.Time;
import ru.turikhay.util.json.ExposeExclusion;

public abstract class VersionList {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Gson gson;
    protected final Map<String, Version> byName = new HashMap<String, Version>();
    protected final List<Version> versions = Collections.synchronizedList(new ArrayList());
    protected final Map<ReleaseType, Version> latest = new HashMap<ReleaseType, Version>();
    private final List<VersionList> dependencies = new ArrayList<VersionList>();

    VersionList() {
        GsonBuilder builder = new GsonBuilder();
        ExposeExclusion.setup(builder);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(true));
        builder.registerTypeAdapter(CompleteVersion.class, (Object)new CompleteVersion.CompleteVersionSerializer());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public synchronized List<Version> getVersions() {
        return new ArrayList<Version>(this.versions);
    }

    public synchronized Map<ReleaseType, Version> getLatestVersions() {
        return new HashMap<ReleaseType, Version>(this.latest);
    }

    public synchronized Version getVersion(String name) {
        if (name != null && !name.isEmpty()) {
            return this.byName.get(name);
        }
        throw new IllegalArgumentException("Name cannot be NULL or empty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompleteVersion getCompleteVersion(Version version) throws JsonSyntaxException, IOException {
        CompleteVersion complete;
        if (version instanceof CompleteVersion) {
            return (CompleteVersion)version;
        }
        if (version == null) {
            throw new NullPointerException("Version cannot be NULL!");
        }
        try (InputStreamReader reader = null;){
            if (version.getUrl() == null) {
                reader = this.getUrl("versions/" + version.getID() + "/" + version.getID() + ".json");
            } else {
                URL url = new URL(version.getUrl());
                InputStream input = RepositoryProxy.canBeProxied(url) ? RepositoryProxy.getProxyRepoList().read(url.toString()) : url.openConnection().getInputStream();
                reader = new InputStreamReader(input, "UTF-8");
            }
            complete = (CompleteVersion)this.gson.fromJson((Reader)reader, CompleteVersion.class);
        }
        complete.setID(version.getID());
        complete.setVersionList(this);
        Collections.replaceAll(this.versions, version, complete);
        return complete;
    }

    public synchronized CompleteVersion getCompleteVersion(String name) throws JsonSyntaxException, IOException {
        Version version = this.getVersion(name);
        return version == null ? null : this.getCompleteVersion(version);
    }

    public synchronized Version getLatestVersion(ReleaseType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return this.latest.get((Object)type);
    }

    public RawVersionList getRawList() throws IOException {
        RawVersionList list;
        String input;
        Object lock = new Object();
        Time.start(lock);
        try (InputStreamReader reader = this.getUrl("versions/versions.json");){
            input = IOUtils.toString((Reader)reader);
        }
        try {
            list = (RawVersionList)this.gson.fromJson(input, RawVersionList.class);
        }
        catch (RuntimeException e) {
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't parse remote repository").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
            throw e;
        }
        for (PartialVersion version : list.versions) {
            version.setVersionList(this);
        }
        LOGGER.info("Got {} in {} ms", (Object)this.getClass().getSimpleName(), (Object)Time.stop(lock));
        return list;
    }

    public synchronized void refreshVersions(RawVersionList versionList) {
        this.clearCache();
        for (PartialVersion partialVersion : versionList.getVersions()) {
            if (partialVersion == null || partialVersion.getID() == null) continue;
            this.versions.add(partialVersion);
            this.byName.put(partialVersion.getID(), partialVersion);
        }
        for (Map.Entry entry : versionList.latest.entrySet()) {
            ReleaseType releaseType = (ReleaseType)((Object)entry.getKey());
            if (releaseType == null) {
                LOGGER.warn("Unknown release type for latest version entry: {}", (Object)entry);
                continue;
            }
            Version version = this.getVersion((String)entry.getValue());
            if (version == null) {
                LOGGER.warn("Cannot find version for latest version entry: {}", (Object)entry);
                continue;
            }
            this.latest.put(releaseType, version);
        }
    }

    public synchronized void refreshVersions() throws IOException {
        this.refreshVersions(this.getRawList());
    }

    synchronized CompleteVersion addVersion(CompleteVersion version) {
        if (version.getID() == null) {
            throw new IllegalArgumentException("Cannot add blank version");
        }
        if (this.getVersion(version.getID()) != null) {
            LOGGER.warn("Version '{}' is already tracked", (Object)version.getID());
            return version;
        }
        this.versions.add(version);
        this.byName.put(version.getID(), version);
        return version;
    }

    synchronized void removeVersion(Version version) {
        if (version == null) {
            throw new NullPointerException("Version cannot be NULL!");
        }
        this.versions.remove(version);
        this.byName.remove(version.getID());
    }

    public synchronized void removeVersion(String name) {
        Version version = this.getVersion(name);
        if (version != null) {
            this.removeVersion(version);
        }
    }

    public String serializeVersion(CompleteVersion version) {
        if (version == null) {
            throw new NullPointerException("CompleteVersion cannot be NULL!");
        }
        return this.gson.toJson((Object)version);
    }

    public abstract boolean hasAllFiles(CompleteVersion var1, OS var2);

    protected abstract InputStreamReader getUrl(String var1) throws IOException;

    synchronized void clearCache() {
        this.byName.clear();
        this.versions.clear();
        this.latest.clear();
    }

    public final List<VersionList> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public final synchronized void addDependancy(VersionList list) {
        if (Objects.requireNonNull(list) == this) {
            throw new IllegalArgumentException("cannot be itself");
        }
        if (list.getDependencies().contains(this)) {
            throw new IllegalArgumentException("invalid nesting");
        }
        this.dependencies.add(list);
    }
}

