/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;

public class VersionFilter {
    private final Set<ReleaseType> types = new HashSet<ReleaseType>(ReleaseType.valuesCollection());
    private final Set<ReleaseType.SubType> subTypes = new HashSet<ReleaseType.SubType>(ReleaseType.SubType.valuesCollection());

    public Set<ReleaseType> getTypes() {
        return this.types;
    }

    public Set<ReleaseType.SubType> getSubTypes() {
        return this.subTypes;
    }

    public VersionFilter onlyForType(ReleaseType ... types) {
        this.types.clear();
        this.include(types);
        return this;
    }

    public VersionFilter onlyForType(ReleaseType.SubType ... subTypes) {
        this.subTypes.clear();
        this.include(subTypes);
        return this;
    }

    public VersionFilter include(ReleaseType ... types) {
        if (types != null) {
            Collections.addAll(this.types, types);
        }
        return this;
    }

    public VersionFilter include(ReleaseType.SubType ... types) {
        if (types != null) {
            Collections.addAll(this.subTypes, types);
        }
        return this;
    }

    public VersionFilter exclude(ReleaseType ... types) {
        if (types != null) {
            Arrays.asList(types).forEach(this.types::remove);
        }
        return this;
    }

    public VersionFilter exclude(ReleaseType.SubType ... types) {
        if (types != null) {
            Arrays.asList(types).forEach(this.subTypes::remove);
        }
        return this;
    }

    public boolean satisfies(Version v) {
        ReleaseType releaseType = v.getReleaseType();
        if (releaseType == null) {
            return true;
        }
        if (!this.types.contains((Object)releaseType)) {
            return false;
        }
        List<ReleaseType.SubType> subTypeList = ReleaseType.SubType.get(v);
        for (ReleaseType.SubType subType : subTypeList) {
            if (this.subTypes.contains((Object)subType)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "VersionFilter" + this.types;
    }
}

